package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.core.exception.IllegalHMACArgumentException
import org.mule.weave.v2.core.exception.InvalidBase64ContentException
import org.mule.weave.v2.core.exception.UnexpectedFunctionCallTypesException
import org.mule.weave.v2.core.exception.UnknownAlgorithmException
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException
import org.mule.weave.v2.core.exception.UserException
import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.types.NullType
import org.mule.weave.v2.model.values.Value

class DefaultNode(lhs: ValueNode[_], rhs: ValueNode[_]) extends ValueNode[Any] with Product2[ValueNode[_], ValueNode[_]] {

  private def onExecute(implicit executionContext: ExecutionContext): Value[Any] = {
    val lhsValue: Value[_] = lhs.execute
    if (NullType.accepts(lhsValue)) {
      rhs.execute
    } else {
      lhsValue
    }
  }

  override def doExecute(implicit executionContext: ExecutionContext): Value[Any] = {
    if (executionContext.serviceManager.settingsService.execution().disableExceptionHandlingOnDefaultOperator) {
      try {
        onExecute
      } catch {
        case e: UnexpectedFunctionCallTypesException if e.actualTypes.contains(NullType) => rhs.execute
        case _: UnsupportedTypeCoercionException                                         => rhs.execute
      }
    } else {
      try {
        onExecute
      } catch {
        case e: UnexpectedFunctionCallTypesException if e.actualTypes.contains(NullType) => rhs.execute
        case _: UnsupportedTypeCoercionException => rhs.execute
        case _: UserException => rhs.execute
        case _: InvalidBase64ContentException => rhs.execute
        case _: UnknownAlgorithmException => rhs.execute
        case _: IllegalHMACArgumentException => rhs.execute
      }
    }
  }

  override def _1: ValueNode[_] = lhs

  override def _2: ValueNode[_] = rhs
}

object DefaultNode {
  def apply(lhs: ValueNode[_], rhs: ValueNode[_]): ValueNode[_] = new DefaultNode(lhs, rhs)
}
