package org.mule.weave.v2.interpreted.node.pattern

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.exception.NoMatchFoundException

class PatternMatcherNode(lhs: ValueNode[_], patterns: Array[PatternNode]) extends ValueNode[Any] with Product {

  private val requiredMaterialize = patterns.exists(_.requiresMaterialize)

  override def doExecute(implicit executionContext: ExecutionContext): Value[_] = {

    val value: Value[_] = if (requiredMaterialize) lhs.execute.materialize else lhs.execute

    var i = 0
    while (i < patterns.length) {
      val patternNode = patterns(i)
      if (patternNode.matches(value)) {
        return patternNode.call(value)
      }
      i = i + 1
    }
    throw new NoMatchFoundException(lhs.location(), value)
  }

  override def productElement(n: Int): Any = {
    n match {
      case 0 => lhs
      case _ => patterns(n - 1)
    }
  }

  override def productArity: Int = patterns.length + 1
}
