package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.schema.SchemaNode
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.types.NameType
import org.mule.weave.v2.model.types.NamespaceType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.NameValue
import org.mule.weave.v2.model.values.Value

class DynamicNameNode(val keyNode: ValueNode[Value[_]]) extends ValueNode[QualifiedName] with Product1[ValueNode[_]] {

  override protected def doExecute(implicit ctx: ExecutionContext): Value[QualifiedName] = {
    NameType.coerce(keyNode.execute, this)
  }

  override def _1: ValueNode[_] = keyNode
}

class NameNode(val keyName: ValueNode[StringType.T], val ns: Option[ValueNode[NamespaceType.T]], val maybeSchema: Option[SchemaNode]) extends ValueNode[QualifiedName] {

  override def productElement(n: Int): Any = {
    n match {
      case 0 => keyName
      case 1 => ns.get
    }
  }

  override def productArity: Int = if (ns.isDefined) 2 else 1

  override def doExecute(implicit executionContext: ExecutionContext): Value[QualifiedName] = {
    NameValue(QualifiedName(keyName.execute.evaluate.toString, ns.map(_.execute.evaluate)), this, schema = maybeSchema.map(_.execute.evaluate))
  }
}

class LiteralNameNode(val keyName: StringNode) extends LiteralValueNode[QualifiedName] {
  override val value: Value[QualifiedName] = NameValue(QualifiedName(keyName.str, None), this)
}

object NameNode {
  def apply(keyName: ValueNode[StringType.T], ns: Option[ValueNode[NamespaceType.T]] = None, mayBeSchema: Option[SchemaNode] = None): ValueNode[QualifiedName] = {
    keyName match {
      case str: StringNode if ns.isEmpty && mayBeSchema.isEmpty => new LiteralNameNode(str)
      case _ => new NameNode(keyName, ns, mayBeSchema)
    }
  }
}