package org.mule.weave.v2.interpreted.node.structure.header.directives

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.ValueNode

final class FunctionDirective(variable: NameSlot, literal: ValueNode[_]) extends Directive with Product2[NameSlot, ValueNode[_]] {

  override def execute(implicit ctx: ExecutionContext): Unit = {
    ctx.executionStack().setVariable(variable.slot, literal.execute)
  }

  override def _1: NameSlot = variable

  override def _2: ValueNode[_] = literal
}
