package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.structure.KeyValuePair
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.types._
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.AttributeDelegateValue
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math.Number

object ArrayFilterFunctionValue extends BinaryFunctionValue {

  val L = ArrayType

  val R = FunctionType

  override def doExecute(lhs: L.V, rhs: R.V)(implicit ctx: EvaluationContext): ArrayValue = {
    var i: Int = 0
    val filtered = lhs.evaluate.toIterator()
      //We need to materialize as it is used in the function and returned
      .map(_.materialize)
      .filter((v: Value[_]) => {
        val application = rhs.call(v, NumberValue(Number(i), this))
        val b = BooleanType.coerce(application).evaluate(ctx)
        i = i + 1
        b
      })
    ArrayValue(ArraySeq(filtered, materializedValues = true), this)
  }

}

object ObjectFilterFunctionValue extends BinaryFunctionValue {
  override val L = ObjectType
  override val R = FunctionType

  override def doExecute(lhs: L.V, rhs: R.V)(implicit ctx: EvaluationContext): ObjectValue = {
    val objectSeq: ObjectSeq = lhs.evaluate
    val keyValuePairs = objectSeq.toIterator()
    var i: Int = 0
    val filteredEntries: Iterator[KeyValuePair] = keyValuePairs
      //We need to materialize as it is used in the function and returned
      .map(_.materialize())
      .filter((kvp: KeyValuePair) => {
        val application = rhs.call(AttributeDelegateValue(kvp), kvp._1, NumberValue(Number(i), this))
        val b = BooleanType.coerce(application).evaluate(ctx)
        i += 1
        b
      })
    ObjectValue(ObjectSeq(filteredEntries, materializedValues = true), this)
  }

}