package org.mule.weave.v2.runtime.core.operator.equality

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.UnknownLocation
import org.mule.weave.v2.parser.location.WeaveLocation

class EqOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  override val L = AnyType

  override val R = AnyType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[Boolean] = {
    BooleanValue(leftValue.equals(rightValue), this)
  }
}

object EqOperator extends EqOperator(UnknownLocation)