package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.core.exception.InvalidSelectionException
import org.mule.weave.v2.core.exception.StrictSelectionOverNullSelection
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.NameType
import org.mule.weave.v2.model.types.NullType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.helper.AttributeHelper
import org.mule.weave.v2.parser.location.WeaveLocation

class ObjectAttributeMultiValueSelectorOperator(override val location: WeaveLocation) extends BinaryFunctionValue {

  val delegate = KeyMultiValueSelectorOperator(location)
  override val L = AnyType

  override val R = NameType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val attrsValue = AttributeHelper.attributesAsObject(leftValue)
    delegate.doExecute(attrsValue.getOrElse(ObjectValue.empty), rightValue)
  }
}

class ArrayAttributeMultiValueSelectorOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  val delegate = ArrayMultiValueSelectorOperator(location)

  override val L = ArrayType

  override val R = NameType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val array: ArraySeq = leftValue.evaluate
    val attributes = array.toIterator().flatMap((v: Value[_]) => {
      AttributeHelper.attributesAsObject(v)
    })

    delegate.doExecute(ArrayValue(attributes, this), rightValue)
  }
}

class NullAttributeMultiValueSelectorOperator(override val location: WeaveLocation) extends BinaryFunctionValue {
  override val L = NullType

  override val R = NameType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    throw InvalidSelectionException(new StrictSelectionOverNullSelection(this))
  }

}

