package org.mule.weave.v2.interpreted.module.reader.exception

import org.mule.weave.v2.core.exception.ReaderException
import org.mule.weave.v2.module.reader.ReaderInput
import org.mule.weave.v2.module.reader.ReaderLocation
import org.mule.weave.v2.parser.location.Location

class WeaveReaderException(val message: String, val location: Location) extends ReaderException

object WeaveReaderException {
  def apply(target: String, location: ReaderLocation, errorChar: Char, inputName: String): WeaveReaderException = {
    val index = location.index
    val line = location.line
    val col = location.column

    val isEOI = errorChar == ReaderInput.EOI
    val message = if (isEOI && index == 0) {
      s"Unable to parse empty input"
    } else {
      val unexpected =
        if (!isEOI) {
          val c = if (Character.isISOControl(errorChar)) "\\u%04x" format errorChar.toInt else errorChar.toString
          s"character '$c'"
        } else "end-of-input"
      s"Unexpected $unexpected at $inputName@[$line:$col] (line:column), expected $target"
    }

    new WeaveReaderException(message, location)
  }

}
