package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.core.functions.EmptyFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.DataFormatManager

object DataFormatDescriptorsFunctionValue extends EmptyFunctionValue {

  override protected def doExecute()(implicit ctx: EvaluationContext): Value[_] = {
    val dfd = DataFormatManager.modules.map(df => {
      DataFormatDescriptorConverter.toObjectValue(df)
    })
    ArrayValue(dfd)
  }
}
