package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.types.ObjectType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class ArrayDescendantsSelectorOperator(includeThis: Boolean, override val location: WeaveLocation) extends UnaryFunctionValue {
  override val R = ArrayType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    if (includeThis) {
      val materializedArray = v.materialize
      ArrayValue(ArraySeq(ArraySeq(Seq(materializedArray)), materializedArray.evaluate.descendants), this)
    } else {
      ArrayValue(v.evaluate.descendants, this)
    }
  }
}

class ObjectDescendantsSelectorOperator(includeThis: Boolean, override val location: WeaveLocation) extends UnaryFunctionValue {
  override val R = ObjectType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    if (includeThis) {
      val materializedObject = v.materialize
      ArrayValue(ArraySeq(ArraySeq(Seq(materializedObject)), materializedObject.evaluate.descendants), this)
    } else {
      ArrayValue(v.evaluate.descendants, this)
    }
  }
}

object DescendantsSelectorOperator {
  def value(includeThis: Boolean, location: WeaveLocation): Array[UnaryFunctionValue] = Array(new ArrayDescendantsSelectorOperator(includeThis, location), new ObjectDescendantsSelectorOperator(includeThis, location))
}