package org.mule.weave.v2.runtime.utils

import org.mule.weave.v2.model.values.BooleanValue
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.ObjectValueBuilder
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.utils.ResultTypeBuilder.ERROR_KEY
import org.mule.weave.v2.runtime.utils.ResultTypeBuilder.RESULT_KEY
import org.mule.weave.v2.runtime.utils.ResultTypeBuilder.SUCCESS_KEY

class ResultTypeBuilder {
  private var _success: Boolean = false
  private var _result: Option[Value[_]] = None
  private var _error: Option[Value[_]] = None

  def withResult(result: Value[_]): ResultTypeBuilder = {
    this._result = Some(result)
    this._success = true
    this
  }

  def withError(error: Value[_]): ResultTypeBuilder = {
    this._error = Some(error)
    this._success = false
    this
  }

  def build(): ObjectValue = {
    val builder = new ObjectValueBuilder()
    builder.addPair(SUCCESS_KEY, if (_success) BooleanValue.TRUE_BOOL else BooleanValue.FALSE_BOOL)
    if (_result.isDefined) {
      builder.addPair(RESULT_KEY, _result.get)
    }
    if (_error.isDefined) {
      builder.addPair(ERROR_KEY, _error.get)
    }
    builder.build
  }
}

object ResultTypeBuilder {
  private val SUCCESS_KEY = "success"
  private val RESULT_KEY = "result"
  private val ERROR_KEY = "error"

  def apply(): ResultTypeBuilder = new ResultTypeBuilder()
}
