%dw 2.0

type AOpen = {
  a: String
}

type AClosed = {|
  a: String
|}

type ANumber = {
  a: Number
}

type BClosed = {|
  b: String
|}

type AOBC = AOpen & BClosed

type AOAO = AOpen & AOpen

type AOAC = AOpen & AClosed

type AOAN = AOpen & ANumber

type C = {
  c: String
}

type BN = {
  b: Number
}

type W = AClosed & {b: Boolean, c: Number}
type X = AClosed & {c: Boolean, b: Number}

type Y = W | X

// This works
var z: Y = {a: "s", c: true, b: 3}

type ObjNum = {a: String} | Number
type ObjBool = {b: String} | Boolean

type S = ObjNum & ObjBool

// This works
var a : S = {a: "3", b: "ff"}
---
{
  "is A": {a: "Hello"} is AOpen,
  "is B": {b: "World"} is BClosed,
  "is AOBC": {a: "Hello", b: "World"} is AOBC, //should be true, but is false
  "is AOAO": {a: "Hello", a: "Worlf"} is AOAO,
  "is AOAC": {a: "Hello", a: "Worlf"} is AOAC,
  "is AOAN": {a: 3} is AOAN,
  "is AOAN": {a: "3"} is AOAN,
  "is AOAN": {a: "3", a: 3} is AOAN,
  "is Y": {a: "s", c: true, b: 3} is Y,
  "is Y": {a: "s", b: true, c: 3} is Y,
  "is not Y": {a: "s", b: true, c: true} is Y,
  "is S": {a: "3", b: "ff"} is S,
}