package org.mule.weave.v2.interpreted

import org.mule.weave.v2.interpreted.marker.ConstantArgumentMarker
import org.mule.weave.v2.interpreted.marker.DoBlockNodeMarker
import org.mule.weave.v2.interpreted.marker.FunctionCallNodeMarker
import org.mule.weave.v2.interpreted.marker.LazyVarDirectiveMarker
import org.mule.weave.v2.interpreted.marker.LiteralValueMarker
import org.mule.weave.v2.interpreted.marker.NameSlotMarker
import org.mule.weave.v2.interpreted.marker.NativeFunctionMarker
import org.mule.weave.v2.interpreted.marker.OverloadedFunctionNotCacheableMarker
import org.mule.weave.v2.interpreted.marker.ParameterReferenceFunctionCallArgumentMarker
import org.mule.weave.v2.interpreted.marker.RequiresMaterializationMarker
import org.mule.weave.v2.interpreted.marker.StaticFunctionCallMarker
import org.mule.weave.v2.interpreted.marker.TypeParameterNodeMarker
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware
import org.mule.weave.v2.parser.phase.SuccessResult
import org.mule.weave.v2.scope.ScopesNavigator

class InterpreterPreCompilerPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware] extends CompilationPhase[T, T] {

  private lazy val markers = Seq(
    new FunctionCallNodeMarker(),
    new LazyVarDirectiveMarker(),
    new StaticFunctionCallMarker(),
    new ParameterReferenceFunctionCallArgumentMarker(),
    new NativeFunctionMarker(),
    new ConstantArgumentMarker(),
    new LiteralValueMarker(),
    new DoBlockNodeMarker(),
    new RequiresMaterializationMarker(),
    new OverloadedFunctionNotCacheableMarker(),
    new NameSlotMarker(),
    new TypeParameterNodeMarker())

  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    val rootNode = source.astNode
    AstNodeHelper.traverse(rootNode, node => {
      markers.foreach(marker => {
        marker.mark(node, source.scope, context)
      })
      true
    })
    SuccessResult(source, context)
  }
}

trait InterpreterPreCompilerMarker {
  def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit
}
