package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode
import org.mule.weave.v2.parser.ast.operators.UnaryOpNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class ConstantArgumentMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case fcn: FunctionCallNode =>
        fcn.args.args.foreach(arg => {
          // Validating annotation argument because constant folding optimization can introduce new node
          if (!arg.isAnnotatedWith(classOf[ConstantArgumentAnnotation])) {
            if (AstNodeHelper.isConstantType(arg, scope)) {
              arg.annotate(new ConstantArgumentAnnotation())
            }
          }
        })

      case bon: BinaryOpNode =>
        // Validating annotation argument because constant folding optimization can introduce new node
        if (!bon.lhs.isAnnotatedWith(classOf[ConstantArgumentAnnotation])) {
          if (AstNodeHelper.isConstantType(bon.lhs, scope)) {
            bon.lhs.annotate(new ConstantArgumentAnnotation())
          }
        }
        // Validating annotation argument because constant folding optimization can introduce new node
        if (!bon.rhs.isAnnotatedWith(classOf[ConstantArgumentAnnotation])) {
          if (AstNodeHelper.isConstantType(bon.rhs, scope)) {
            bon.rhs.annotate(new ConstantArgumentAnnotation())
          }
        }

      case uon: UnaryOpNode =>
        // Validating annotation argument because constant folding optimization can introduce new node
        if (!uon.rhs.isAnnotatedWith(classOf[ConstantArgumentAnnotation])) {
          if (AstNodeHelper.isConstantType(uon.rhs, scope)) {
            uon.rhs.annotate(new ConstantArgumentAnnotation())
          }
        }
      case _ =>
      // Nothing to do
    }
  }
}

class ConstantArgumentAnnotation extends AstNodeAnnotation {
  override def name(): String = {
    "ConstantArgument"
  }
}
