package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class ParameterReferenceFunctionCallArgumentMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    val navigator = scope.astNavigator()
    node match {
      case fcn: FunctionCallNode =>
        val maybeFunctionNode = navigator.parentWithType(fcn, classOf[FunctionNode])
        if (maybeFunctionNode.isDefined) {
          val fn = maybeFunctionNode.get
          fcn.args.args.foreach(arg => {
            if (!arg.isAnnotatedWith(classOf[ParameterReferenceFunctionCallArgumentAnnotation])) {
              if (AstNodeHelper.isFunctionParameter(arg, scope, fn)) {
                arg.annotate(new ParameterReferenceFunctionCallArgumentAnnotation())
              }
            }
          })
        }
      case _ =>
      // Nothing to do
    }
  }
}

class ParameterReferenceFunctionCallArgumentAnnotation extends AstNodeAnnotation {

  override def name(): String = {
    "ParameterReferenceFunctionCallArgument"
  }

}