package org.mule.weave.v2.interpreted.node.structure

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.model.types.BooleanType
import org.mule.weave.v2.model.values.Value

class ConditionalNode(value: ValueNode[_], cond: ValueNode[_]) extends ValueNode[Any] with ConditionalCapableNode {

  override def doExecute(implicit ctx: ExecutionContext): Value[_] = {
    value.execute
  }

  override def condition(implicit ctx: ExecutionContext): Boolean = {
    BooleanType.coerce(cond.execute, cond).evaluate
  }

}
