package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.RuntimeModuleNodeCompiler
import org.mule.weave.v2.interpreted.node.ExecutionNode
import org.mule.weave.v2.parser
import org.mule.weave.v2.parser.annotation.MaterializeVariableAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.AstNavigator

trait AstTransformation {
  def transformOption[T <: ExecutionNode](source: Option[parser.ast.AstNode]): Option[T] = {
    val result: Option[T] = source.map(transform[T])
    result
  }

  def transformSeq[T <: ExecutionNode](source: Seq[parser.ast.AstNode]): Seq[T] = {
    val result: Seq[T] = source.map(transform[T])
    result
  }

  def transformOptionSeq[T <: ExecutionNode](source: Option[Seq[parser.ast.AstNode]]): Option[Seq[T]] = {
    val result: Option[Seq[T]] = source.map(_.map(transform[T]))
    result
  }

  def needsMaterialization(variable: NameIdentifier): Boolean = {
    variable.annotation(classOf[MaterializeVariableAnnotation]).forall(_.needMaterialize)
  }

  def transform[T <: ExecutionNode](astNode: parser.ast.AstNode): T

  def astNavigator(): AstNavigator

  def parsingContext(): ParsingContext

  def moduleLoader(): RuntimeModuleNodeCompiler

  var rootElement: AstNode

  def transformingModule: Boolean = rootElement.isInstanceOf[ModuleNode]
}

