package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.marker.ReferenceAnnotation
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.structure.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.structure.NamespaceNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.parser.exception.WeaveRuntimeException

trait EngineImportTransformations extends AstTransformation with EngineVariableTransformations with EngineHeaderTransformations {

  def transformImportDirectives(root: AstNode): Seq[ImportDirective] = {
    val variableReference: Seq[VariableReferenceNode] = AstNodeHelper.collectChildrenWith(root, classOf[VariableReferenceNode])
    val typeReference: Seq[TypeReferenceNode] = AstNodeHelper.collectChildrenWith(root, classOf[TypeReferenceNode])
    val namespaces: Seq[NamespaceNode] = AstNodeHelper.collectChildrenWith(root, classOf[NamespaceNode])
    val annotations: Seq[AnnotationNode] = AstNodeHelper.collectChildrenWith(root, classOf[AnnotationNode])

    val importedModules: Seq[NameIdentifier] = variableReference.flatMap(vr => {
      vr.variable.annotation(classOf[ReferenceAnnotation])
        .flatMap(_.referenceValue.moduleFQN)
    }) ++
      typeReference.flatMap(tr => {
        tr.variable.annotation(classOf[ReferenceAnnotation])
          .flatMap(_.referenceValue.moduleFQN)
      }) ++
      namespaces.flatMap(ns => {
        ns.prefix.annotation(classOf[ReferenceAnnotation])
          .flatMap(_.referenceValue.moduleFQN)
      }) ++
      annotations.flatMap(annotation => {
        annotation.name.annotation(classOf[ReferenceAnnotation])
          .flatMap(_.referenceValue.moduleFQN)
      })

    val distinctModules = importedModules.distinct
    distinctModules.map((moduleName) => {
      val theParsingContext = parsingContext()
      val nodeLoader = moduleLoader()
      val maybeNode = nodeLoader.compile(moduleName, theParsingContext)
      val module = maybeNode.getOrElse(throw new WeaveRuntimeException(s"Unable to load module ${moduleName.name}", moduleName.location()))
      val moduleSlot: NameSlot = createModuleSlot(moduleName.name)
      _modules.insert(moduleSlot.slot, module.variableTable)
      new ImportDirective(moduleSlot, module)
    })
  }

}
