package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeFunctionUtils.putInto
import org.mule.weave.v2.runtime.core.functions.types.ArrayItemTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.BaseTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.FunctionParamTypesFunction
import org.mule.weave.v2.runtime.core.functions.types.FunctionReturnTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.IntersectionTypeItemsFunction
import org.mule.weave.v2.runtime.core.functions.types.IsArrayTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.IsFunctionTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.IsIntersectionTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.IsLiteralTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.IsObjectTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.IsReferenceTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.IsUnionTypeFunction
import org.mule.weave.v2.runtime.core.functions.types.LiteralTypeValueFunction
import org.mule.weave.v2.runtime.core.functions.types.MetadataOfFunction
import org.mule.weave.v2.runtime.core.functions.types.NameOfFunction
import org.mule.weave.v2.runtime.core.functions.types.ObjectTypeFieldsFunction
import org.mule.weave.v2.runtime.core.functions.types.UnionTypeItemsFunction

import scala.collection.mutable
/**
  * Registers all the functions for the dw::core::Types module
  */
object TypesNativeFunctions {
  def registerFunction(catalog: mutable.Map[String, FunctionValue]): Unit = {
    {
      putInto(ArrayItemTypeFunction, catalog)
      putInto(BaseTypeFunction, catalog)
      putInto(FunctionParamTypesFunction, catalog)
      putInto(FunctionReturnTypeFunction, catalog)
      putInto(IntersectionTypeItemsFunction, catalog)
      putInto(IsArrayTypeFunction, catalog)
      putInto(IsFunctionTypeFunction, catalog)
      putInto(IsIntersectionTypeFunction, catalog)
      putInto(IsLiteralTypeFunction, catalog)
      putInto(IsObjectTypeFunction, catalog)
      putInto(IsReferenceTypeFunction, catalog)
      putInto(IsUnionTypeFunction, catalog)
      putInto(LiteralTypeValueFunction, catalog)
      putInto(MetadataOfFunction, catalog)
      putInto(ObjectTypeFieldsFunction, catalog)
      putInto(NameOfFunction, catalog)
      putInto(UnionTypeItemsFunction, catalog)
    }
  }
}
