package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.math
import org.mule.weave.v2.model.values.math.Number
import org.mule.weave.v2.runtime.core.exception.DivisionByZeroException
import org.mule.weave.v2.runtime.core.exception.UnboundDecimalExpansionException

import java.math.MathContext

object BigDecimalDivisionFunctionValue extends BaseBigDecimalBinaryFunctionValue {
  override def applyOperation(dividend: math.Number, divisor: math.Number, context: MathContext)(implicit ctx: EvaluationContext): math.Number = {
    try {
      Number(dividend.toBigDecimal.bigDecimal.divide(divisor.toBigDecimal.bigDecimal, context))
    } catch {
      case e: java.lang.ArithmeticException => if (e.getMessage.contains("decimal expansion")) {
        throw new UnboundDecimalExpansionException(this.location())
      } else {
        throw new DivisionByZeroException(this.location())
      }
    }
  }
}
