package org.mule.weave.v2.runtime.core.functions.math

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.math

import java.math.MathContext

object BigDecimalPowerFunctionValue extends BaseBigDecimalBinaryFunctionValue {
  override def applyOperation(base: math.Number, exponent: math.Number, context: MathContext)(implicit ctx: EvaluationContext): math.Number = {
    val mathService = ctx.serviceManager.mathService()
    mathService.pow(base, exponent, context)
  }
}

