package org.mule.weave.v2.runtime.core.operator.periods

import java.time.Period

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.LocalDateType
import org.mule.weave.v2.model.values.PeriodValue
import org.mule.weave.v2.model.values.Value

object BetweenLocalDateOperator extends BinaryFunctionValue {

  override val L = LocalDateType

  override val R = LocalDateType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    PeriodValue(Period.between(rightValue.evaluate, leftValue.evaluate), this)
  }
}
