%dw 2.0
output application/json

import * from dw::util::Math

var int10dec30 = 1234567890.123456789012345678901234567891
var int10dec10 = 1234567890.1234567890
---
{
  decimalAdd: decimalAdd(1.10, 1.100001, {precision: 3}),
  decimalSubtract: decimalSubtract(2, 1.000000001, { precision: 32}),
  roundTo5dec: decimalRound(int10dec30, { precision: 15, roundingMode: "HALF_DOWN"}),
  unlimitedPrec: [int10dec10, int10dec10, int10dec10, int10dec10, int10dec10] reduce ((item, accum) -> decimalMultiply(item, accum, UNLIMITED_CONTEXT)),
  multUp: decimalMultiply(int10dec30, int10dec30, { precision: 40, roundingMode: "UP" }),
  roundedInfiniteDiv: decimalDivide(1, 3, { precision: 10, roundingMode: "HALF_EVEN" }),
  round: decimalRound(PI, { precision: 3, roundingMode: "FLOOR" }),
  sqrt: decimalSqrt(2, { precision: 5 }),
  decimalPow: decimalPow(decimalSqrt(2.001, { precision: 20 }), 2, { precision: 4, roundingMode: "HALF_UP" })
}