package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.types.TypeParameterNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class TypeParameterNodeMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case trn: TypeReferenceNode =>
        if (!trn.variable.isAnnotatedWith(classOf[TypeParameterNodeAnnotation])) {
          val maybeReference = scope.resolveVariable(trn.variable)
          maybeReference match {
            case Some(reference) =>
              if (reference.scope.astNode.isInstanceOf[FunctionNode]) {
                val maybeParent = reference.scope.astNavigator().parentOf(reference.referencedNode)
                val isTypeParameterNode = maybeParent.isDefined &&
                  maybeParent.get.isInstanceOf[TypeParameterNode]
                if (isTypeParameterNode) {
                  trn.variable.annotate(new TypeParameterNodeAnnotation())
                }
              }
            case _ =>
            // Nothing to do
          }
        }

      case _ =>
      // Nothing to do
    }
  }
}

class TypeParameterNodeAnnotation extends AstNodeAnnotation {

  override def name(): String = {
    "TypeParameterNode"
  }
}
