package org.mule.weave.v2.interpreted.node

import org.mule.weave.v2.interpreted.ExecutionContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.runtime.exception.InvalidVariableNameException

class VariableReferenceNode(val variable: NameSlot, val crossModuleReference: Boolean) extends ValueNode[Any] {

  override def doExecute(implicit ctx: ExecutionContext): Value[_] = {
    val result = if (crossModuleReference) {
      val moduleName: NameSlot = variable.module.get
      ctx.executionStack().getVariable(moduleName.slot, variable.slot)
    } else {
      ctx.executionStack().getVariable(variable.slot)
    }
    if (result != null) {
      result
    } else {
      throw new InvalidVariableNameException(location(), variable.name)
    }
  }

  override def productElement(n: Int): Any = throw new IndexOutOfBoundsException(n + " is out of bound.")

  override def productArity: Int = 0

}
object VariableReferenceNode {
  def apply(variable: NameSlot): VariableReferenceNode = new VariableReferenceNode(variable, variable.module.isDefined)
}
