package org.mule.weave.v2.runtime.core

import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeValueProvider
import org.mule.weave.v2.runtime.core.functions.BinariesNativeFunctions
import org.mule.weave.v2.runtime.core.functions.CoreNativeFunctions
import org.mule.weave.v2.runtime.core.functions.NumbersNativeFunction
import org.mule.weave.v2.runtime.core.functions.PeriodsNativeFunctions
import org.mule.weave.v2.runtime.core.functions.RuntimeNativeFunctions
import org.mule.weave.v2.runtime.core.functions.StringsNativeFunctions
import org.mule.weave.v2.runtime.core.functions.TypesNativeFunctions

import scala.collection.mutable

class SystemNativeValueProvider extends NativeValueProvider {

  private val catalog: mutable.HashMap[String, FunctionValue] = new mutable.HashMap[String, FunctionValue]()

  CoreNativeFunctions.registerFunction(catalog)
  StringsNativeFunctions.registerFunction(catalog)
  NumbersNativeFunction.registerFunction(catalog)
  TypesNativeFunctions.registerFunction(catalog)
  BinariesNativeFunctions.registerFunction(catalog)
  RuntimeNativeFunctions.registerFunction(catalog)
  PeriodsNativeFunctions.registerFunction(catalog)

  override def name(): String = "system"

  override def getNativeFunction(name: String): Option[FunctionValue] = {
    catalog.get(name)
  }
}
