package org.mule.weave.v2.runtime.core.functions.collections

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.ArraySeq
import org.mule.weave.v2.model.types.ArrayType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.Value

import scala.collection.mutable.ArrayBuffer

object ArrayFlattenFunctionValue extends UnaryFunctionValue {
  val R = ArrayType

  override def doExecute(lhs: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    val flatten: Iterator[Value[_]] = new FlattenArrayIterator(lhs.evaluate.toIterator())
    ArrayValue(flatten, this)
  }
}

class FlattenArrayIterator(val toFlatten: Iterator[Value[_]])(implicit executionContext: EvaluationContext) extends Iterator[Value[_]] {

  var iteratorProviders: ArrayBuffer[Iterator[Value[_]]] = ArrayBuffer(toFlatten)
  var nextValue: Value[_] = _
  var nextValues: Iterator[Value[_]] = Iterator.empty

  def currentIterator(): Iterator[Value[_]] = {
    var lastOption = iteratorProviders.lastOption
    while (lastOption.isDefined && !lastOption.get.hasNext) {
      iteratorProviders.remove(iteratorProviders.length - 1)
      lastOption = iteratorProviders.lastOption
    }
    lastOption.getOrElse(Iterator.empty)
  }

  def loadNext(): Boolean = {
    var foundNext: Boolean = false
    var currIterator: Iterator[Value[_]] = currentIterator()
    while (!foundNext && currIterator.hasNext) {
      val theValue = currIterator.next()
      theValue.evaluate match {
        case as: ArraySeq => {
          val iterator = as.toIterator()
          iterator match {
            case fi: FlattenArrayIterator => {
              //avoid stacking FlattenIterators
              //Pull it up to avoid StackOverflow
              iteratorProviders.+=(fi.toFlatten)
              iteratorProviders.+=(fi.nextValues)
              if (fi.nextValue != null) {
                // if fi already loaded a value, then use it
                nextValue = fi.nextValue
                foundNext = true
              }
            }
            case _ => {
              nextValues = iterator
              foundNext = nextValues.hasNext
            }
          }
        }
        case _ => {
          nextValue = theValue
          foundNext = true
        }
      }
      if (!foundNext) {
        currIterator = currentIterator()
      }
    }
    foundNext
  }

  override def hasNext: Boolean = {
    val hasNext = nextValue != null || nextValues.hasNext
    if (!hasNext) {
      loadNext()
    } else {
      true
    }
  }

  override def next(): Value[_] = {
    if (hasNext) {
      if (nextValue != null) {
        val result: Value[_] = nextValue
        nextValue = null
        result
      } else {
        nextValues.next()
      }
    } else {
      Iterator.empty.next()
    }
  }
}
