package org.mule.weave.v2.runtime.core.operator.selectors

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.core.exception.InvalidSelectionException
import org.mule.weave.v2.core.exception.NoNamespaceDefinedException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.capabilities.KeyCapable
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.KeyType
import org.mule.weave.v2.model.types.NameType
import org.mule.weave.v2.model.values.NamespaceValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation

class NamespaceSelectorOperator(override val location: WeaveLocation) extends UnaryFunctionValue {
  override val R = AnyType

  override def doExecute(rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    rightValue match {
      case key if NameType.accepts(key) =>
        fromKey(NameType.coerce(key))
      case key if KeyType.accepts(key) =>
        fromKey(KeyType.coerce(key))
      case ac: KeyCapable =>
        fromKey(ac.key())
      case _ => throw InvalidSelectionException(new NoNamespaceDefinedException(this.location))
    }
  }

  def fromKey(key: Value[QualifiedName])(implicit ctx: EvaluationContext): NamespaceValue = {
    key.evaluate.namespace.map(NamespaceValue(_, this))
      .getOrElse(throw InvalidSelectionException(new NoNamespaceDefinedException(this.location)))
  }
}
