%dw 2.0

fun checkBusinessTime (currentDate,cutOffBusinessHour,holidayList,totalBusinessDays,businessDaysList) =
	if(currentDate.hour > cutOffBusinessHour)
		(getNextBusinessDay(currentDate + |P1D|,cutOffBusinessHour,holidayList,totalBusinessDays,businessDaysList))
	else
		(getNextBusinessDay(currentDate,cutOffBusinessHour,holidayList,totalBusinessDays,businessDaysList))

fun getNextBusinessDay (currentDate,cutOffBusinessHour,holidayList,totalBusinessDays,businessDaysList) =
	if (((holidayList) contains ((currentDate as Date) as String {format : "yyyyMMdd"}) ) or (currentDate.dayOfWeek >= 6) )
		 (getNextBusinessDay(currentDate + |P1D|,cutOffBusinessHour, holidayList,totalBusinessDays,businessDaysList) )
	else
		(collectBusinessDays(currentDate + |P1D|,cutOffBusinessHour,(businessDaysList << currentDate  as String {format : "yyyy-MM-dd"}),totalBusinessDays - 1,holidayList))

fun collectBusinessDays(currentDate,cutOffBusinessHour,businessDaysList,totalBusinessDays,holidayList) =

	if(totalBusinessDays>0)
		((checkBusinessTime(currentDate, cutOffBusinessHour ,holidayList,totalBusinessDays,businessDaysList ) ) )
	else
		businessDaysList

output application/json
---
{
    "test": collectBusinessDays("2020-04-04T00:00:00-07:00",16,["2020-04-04T00:00:00-07:00"],10,"20210101,20210407,20210118,20210215,20210531,20210705,20210906,20211011,20211111,20211125")
}