%dw 2.0

ns ns0 http://www.opentravel.org/OTA/2003/05

fun mapFareInfo(fareInfo) =
  {
    (arrivalAirport: {
      codeContext: fareInfo.ns0#ArrivalAirport.@CodeContext,
      locationCode: fareInfo.ns0#ArrivalAirport.@LocationCode
    }) if fareInfo.ns0#ArrivalAirport?,
    (departureAirport: {
      codeContext: fareInfo.ns0#DepartureAirport.@CodeContext,
      locationCode: fareInfo.ns0#DepartureAirport.@LocationCode
    }) if fareInfo.ns0#DepartureAirport?,
    departureDate: fareInfo.ns0#DepartureDate,
    fareReference: fareInfo.ns0#FareReference,
    (marketingAirline: fareInfo.*ns0#MarketingAirline default [] map ((marketingAirline, indexOfMarketingAirline) -> {
      code: marketingAirline.@Code,
      codeContext: marketingAirline.@CodeContext,
      companyShortName: marketingAirline.@CompanyShortName,
      travelSector: marketingAirline.@TravelSector
    })) if fareInfo.*ns0#MarketingAirline?,
    negotiatedFare: fareInfo.@NegotiatedFare,
    negotiatedFareCode: fareInfo.@NegotiatedFareCode,
    (ruleInfo: {
      lengthOfStayRules: {
        maximumStay: {
          maxStay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@MaxStay,
          maxStayDate: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@MaxStayDate,
          returnTimeOfDay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@ReturnTimeOfDay,
          returnType: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@ReturnType,
          stayUnit: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@StayUnit
        },
        minimumStay: {
          minStay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@MinStay,
          minStayDate: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@MinStayDate,
          returnTimeOfDay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@ReturnTimeOfDay,
          stayUnit: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@StayUnit
        },
        stayRestrictionsInd: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.@StayRestrictionsInd
      },
      resTicketingRules: {
        advResTicketing: {
          advResInd: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.@AdvResInd,
          advReservation: {
            latestPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestPeriod,
            latestTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestTimeOfDay,
            latestUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestUnit
          },
          advTicketing: {
            fromDepartPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartPeriod,
            fromDepartTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartTimeOfDay,
            fromDepartUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartUnit,
            fromResPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResPeriod,
            fromResTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResTimeOfDay,
            fromResUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResUnit
          },
          advTicketingInd: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.@AdvTicketingInd
        }
      }
    }) if fareInfo.ns0#RuleInfo?,
    tpaExtensions: {
      cabin: {
        cabin: fareInfo.ns0#"TPA_Extensions".ns0#Cabin.@Cabin
      },
      (fareNote: fareInfo.ns0#"TPA_Extensions".*ns0#FareNote default [] map ((fareNote, indexOfFareNote) -> {
        contentId: fareNote.@ContentID,
        fareTypeName: fareNote.@FareTypeName,
        priorityLevel: fareNote.@PriorityLevel
      })) if fareInfo.ns0#"TPA_Extensions".*ns0#FareNote?,
      (meal: {
        code: fareInfo.ns0#"TPA_Extensions".ns0#Meal.@Code
      }) if fareInfo.ns0#"TPA_Extensions".ns0#Meal?,
      (rule: fareInfo.ns0#"TPA_Extensions".*ns0#Rule default [] map ((rule, indexOfRule) -> {
        id: rule.@ID,
        "type": rule.@Type
      })) if fareInfo.ns0#"TPA_Extensions".*ns0#Rule?,
      seatsRemaining: {
        belowMin: fareInfo.ns0#"TPA_Extensions".ns0#SeatsRemaining.@BelowMin,
        number: fareInfo.ns0#"TPA_Extensions".ns0#SeatsRemaining.@Number
      }
    }
  }

fun mapAirItineraryPricingInfo(airItineraryPricingInfo) =
  {
    advancedPurchaseDate: airItineraryPricingInfo.@AdvancedPurchaseDate,
    alternateCityOption: airItineraryPricingInfo.@AlternateCityOption,
    brandId: airItineraryPricingInfo.@BrandID,
    brandsOnAnyMarket: airItineraryPricingInfo.@BrandsOnAnyMarket,
    cachePartition: airItineraryPricingInfo.@CachePartition,
    cachePartitionPriority: airItineraryPricingInfo.@CachePartitionPriority,
    cacheVersion: airItineraryPricingInfo.@CacheVersion,
    cachedItin: airItineraryPricingInfo.@CachedItin,
    fareInfos: {
      fareInfo: airItineraryPricingInfo.ns0#FareInfos.*ns0#FareInfo default [] map ((fareInfo, indexOfFareInfo) -> mapFareInfo(fareInfo))
    },
    fareReturned: airItineraryPricingInfo.@FareReturned,
    fareStatus: airItineraryPricingInfo.@FareStatus,
    flexibleFareId: airItineraryPricingInfo.@FlexibleFareID,
    hoursSinceCreation: airItineraryPricingInfo.@HoursSinceCreation,
    itinTotalFare: {
      baseFare: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#BaseFare.@Amount,
        currencyCode: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#BaseFare.@CurrencyCode,
        decimalPlaces: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#BaseFare.@DecimalPlaces
      },
      (currencyConversions: {
        conversion: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#CurrencyConversions.*ns0#Conversion default [] map ((conversion, indexOfConversion) -> {
          from: conversion.@From,
          rateOfExchange: conversion.@RateOfExchange,
          to: conversion.@To
        })
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#CurrencyConversions?,
      equivFare: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@Amount,
        currencyCode: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@CurrencyCode,
        decimalPlaces: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@DecimalPlaces,
        effectiveDeviationType: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@EffectiveDeviationType,
        effectivePriceDeviation: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@EffectivePriceDeviation
      },
      (extras: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Extras.@Amount
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Extras?,
      fareConstruction: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#FareConstruction.@Amount,
        currencyCode: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#FareConstruction.@CurrencyCode,
        decimalPlaces: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#FareConstruction.@DecimalPlaces
      },
      (fees: {
        fee: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Fees.*ns0#Fee default [] map ((fee, indexOfFee) -> {
          amount: fee.@Amount,
          currencyCode: fee.@CurrencyCode,
          decimalPlaces: fee.@DecimalPlaces,
          feeCode: fee.@FeeCode
        })
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Fees?,
      negotiatedFare: airItineraryPricingInfo.ns0#ItinTotalFare.@NegotiatedFare,
      negotiatedFareCode: airItineraryPricingInfo.ns0#ItinTotalFare.@NegotiatedFareCode,
      (nonRefundableBaseFare: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#NonRefundableBaseFare.@Amount,
        currencyCode: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#NonRefundableBaseFare.@CurrencyCode,
        decimalPlaces: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#NonRefundableBaseFare.@DecimalPlaces
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#NonRefundableBaseFare?,
      (obFees: {
        obFee: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#OBFees.*ns0#OBFee default [] map ((oBFee, indexOfOBFee) -> {
          amount: oBFee.@Amount,
          currencyCode: oBFee.@CurrencyCode,
          decimalPlaces: oBFee.@DecimalPlaces,
          description: oBFee.@Description,
          "type": oBFee.@Type
        }),
        tTypeAmount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#OBFees.@TTypeAmount
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#OBFees.*ns0#OBFee?,
      (penaltiesInfo: {
        penalty: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#PenaltiesInfo.*ns0#Penalty default [] map ((penalty, indexOfPenalty) -> {
          amount: penalty.@Amount,
          applicability: penalty.@Applicability,
          cat16Info: penalty.@Cat16Info,
          cat16TextOnly: penalty.*ns0#Cat16TextOnly default [] map ((cat16TextOnly, indexOfCat16TextOnly) -> {
            fareBasisCode: cat16TextOnly.@FareBasisCode,
            fareComponentId: cat16TextOnly.@FareComponentID
          }),
          changeable: penalty.@Changeable,
          conditionsApply: penalty.@ConditionsApply,
          currencyCode: penalty.@CurrencyCode,
          decimalPlaces: penalty.@DecimalPlaces,
          refundable: penalty.@Refundable,
          "type": penalty.@Type
        })
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#PenaltiesInfo?,
      (rateOfExchange: {
        value: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#RateOfExchange.@Value
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#RateOfExchange?,
      (reissueInfoList: {
        reissueInfo: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#ReissueInfoList.*ns0#ReissueInfo default [] map ((reissueInfo, indexOfReissueInfo) -> {
          changeFees: {
            changeFee: {
              amount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@Amount,
              changeFeeNotApplicable: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeNotApplicable,
              changeFeeWaived: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeWaived,
              currencyCode: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@CurrencyCode,
              decimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@DecimalPlaces,
              highestChangeFee: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@HighestChangeFee,
              paymentAmount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentAmount,
              paymentCurrency: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentCurrency,
              paymentDecimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentDecimalPlaces
            }
          },
          formOfRefund: reissueInfo.@FormOfRefund,
          reissueDoesNotAllowElectronicTicket: reissueInfo.@ReissueDoesNotAllowElectronicTicket,
          reissueRequiresElectronicTicket: reissueInfo.@ReissueRequiresElectronicTicket,
          reissueResultFromTag: reissueInfo.@ReissueResultFromTag,
          residualIdicator: reissueInfo.@ResidualIdicator,
          taxRefundable: reissueInfo.@TaxRefundable,
          typeOfReissueTransaction: reissueInfo.@TypeOfReissueTransaction,
          typeOfServiceFee: reissueInfo.@TypeOfServiceFee
        })
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#ReissueInfoList?,
      (serviceFee: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#ServiceFee.@Amount,
        taxAmount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#ServiceFee.@TaxAmount
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#ServiceFee?,
      taxes: {
        (fareComponentsTaxes: {
          fareComponentTaxes: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#FareComponentsTaxes.*ns0#FareComponentTaxes default [] map ((fareComponentTaxis, indexOfFareComponentTaxis) -> {
            flightSegment: fareComponentTaxis.*ns0#FlightSegment default [] map ((flightSegment, indexOfFlightSegment) -> {
              arrivalAirportCode: flightSegment.@ArrivalAirportCode,
              departureAirportCode: flightSegment.@DepartureAirportCode
            }),
            tax: fareComponentTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
              amount: tax.@Amount,
              applyToReissue: tax.@ApplyToReissue,
              carrierCode: tax.@CarrierCode,
              countryCode: tax.@CountryCode,
              currencyCode: tax.@CurrencyCode,
              decimalPlaces: tax.@DecimalPlaces,
              maxAmount: tax.@MaxAmount,
              minAmount: tax.@MinAmount,
              minMaxCurrency: tax.@MinMaxCurrency,
              pointsAmount: tax.@PointsAmount,
              publishedAmount: tax.@PublishedAmount,
              publishedCurrency: tax.@PublishedCurrency,
              rateUsed: tax.@RateUsed,
              refundable: tax.@Refundable,
              reissueCurrency: tax.@ReissueCurrency,
              reissueMaxAmount: tax.@ReissueMaxAmount,
              reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
              reissueTaxRefundable: tax.@ReissueTaxRefundable,
              reissueTaxType: tax.@ReissueTaxType,
              stationCode: tax.@StationCode,
              taxCode: tax.@TaxCode,
              taxOnChangeFee: tax.@TaxOnChangeFee
            }),
            taxSummary: fareComponentTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
              amount: taxSummary.@Amount,
              countryCode: taxSummary.@CountryCode,
              currencyCode: taxSummary.@CurrencyCode,
              decimalPlaces: taxSummary.@DecimalPlaces,
              pointsAmount: taxSummary.@PointsAmount,
              publishedAmount: taxSummary.@PublishedAmount,
              publishedCurrency: taxSummary.@PublishedCurrency,
              stationCode: taxSummary.@StationCode,
              taxCode: taxSummary.@TaxCode
            })
          })
        }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#FareComponentsTaxes?,
        (legsTaxes: {
          legTaxes: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#LegsTaxes.*ns0#LegTaxes default [] map ((legTaxis, indexOfLegTaxis) -> {
            number: legTaxis.@Number,
            tax: legTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
              amount: tax.@Amount,
              applyToReissue: tax.@ApplyToReissue,
              carrierCode: tax.@CarrierCode,
              countryCode: tax.@CountryCode,
              currencyCode: tax.@CurrencyCode,
              decimalPlaces: tax.@DecimalPlaces,
              maxAmount: tax.@MaxAmount,
              minAmount: tax.@MinAmount,
              minMaxCurrency: tax.@MinMaxCurrency,
              pointsAmount: tax.@PointsAmount,
              publishedAmount: tax.@PublishedAmount,
              publishedCurrency: tax.@PublishedCurrency,
              rateUsed: tax.@RateUsed,
              refundable: tax.@Refundable,
              reissueCurrency: tax.@ReissueCurrency,
              reissueMaxAmount: tax.@ReissueMaxAmount,
              reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
              reissueTaxRefundable: tax.@ReissueTaxRefundable,
              reissueTaxType: tax.@ReissueTaxType,
              stationCode: tax.@StationCode,
              taxCode: tax.@TaxCode,
              taxOnChangeFee: tax.@TaxOnChangeFee
            }),
            taxSummary: legTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
              amount: taxSummary.@Amount,
              countryCode: taxSummary.@CountryCode,
              currencyCode: taxSummary.@CurrencyCode,
              decimalPlaces: taxSummary.@DecimalPlaces,
              pointsAmount: taxSummary.@PointsAmount,
              publishedAmount: taxSummary.@PublishedAmount,
              publishedCurrency: taxSummary.@PublishedCurrency,
              stationCode: taxSummary.@StationCode,
              taxCode: taxSummary.@TaxCode
            })
          })
        }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#LegsTaxes?,
        tax: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.*ns0#Tax default [] map ((tax, indexOfTax) -> {
          amount: tax.@Amount,
          applyToReissue: tax.@ApplyToReissue,
          carrierCode: tax.@CarrierCode,
          countryCode: tax.@CountryCode,
          currencyCode: tax.@CurrencyCode,
          decimalPlaces: tax.@DecimalPlaces,
          maxAmount: tax.@MaxAmount,
          minAmount: tax.@MinAmount,
          minMaxCurrency: tax.@MinMaxCurrency,
          pointsAmount: tax.@PointsAmount,
          publishedAmount: tax.@PublishedAmount,
          publishedCurrency: tax.@PublishedCurrency,
          rateUsed: tax.@RateUsed,
          refundable: tax.@Refundable,
          reissueCurrency: tax.@ReissueCurrency,
          reissueMaxAmount: tax.@ReissueMaxAmount,
          reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
          reissueTaxRefundable: tax.@ReissueTaxRefundable,
          reissueTaxType: tax.@ReissueTaxType,
          stationCode: tax.@StationCode,
          taxCode: tax.@TaxCode,
          taxOnChangeFee: tax.@TaxOnChangeFee
        }),
        (taxSummary: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
          amount: taxSummary.@Amount,
          countryCode: taxSummary.@CountryCode,
          currencyCode: taxSummary.@CurrencyCode,
          decimalPlaces: taxSummary.@DecimalPlaces,
          pointsAmount: taxSummary.@PointsAmount,
          publishedAmount: taxSummary.@PublishedAmount,
          publishedCurrency: taxSummary.@PublishedCurrency,
          stationCode: taxSummary.@StationCode,
          taxCode: taxSummary.@TaxCode
        })) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.*ns0#TaxSummary?,
        (totalTax: {
          amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#TotalTax.@Amount,
          currencyCode: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#TotalTax.@CurrencyCode,
          decimalPlaces: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#TotalTax.@DecimalPlaces
        }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#TotalTax?
      },
      totalFare: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalFare.@Amount,
        currencyCode: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalFare.@CurrencyCode,
        decimalPlaces: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalFare.@DecimalPlaces
      },
      (totalMileage: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalMileage.@Amount
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalMileage?,
      (totalWithExtras: {
        amount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalWithExtras.@Amount
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalWithExtras?,
      (tpaExtensions: {
        baggageInformationList: {
          baggageInformation: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#BaggageInformationList.*ns0#BaggageInformation default [] map ((baggageInformation, indexOfBaggageInformation) -> {
            airlineCode: baggageInformation.@AirlineCode,
            allowance: baggageInformation.*ns0#Allowance default [] map ((allowance, indexOfAllowance) -> {
              description1: allowance.@Description1,
              description2: allowance.@Description2,
              pieces: allowance.@Pieces,
              unit: allowance.@Unit,
              weight: allowance.@Weight
            }),
            charge: baggageInformation.*ns0#Charge default [] map ((charge, indexOfCharge) -> {
              description1: charge.@Description1,
              description2: charge.@Description2,
              equivalentAmount: charge.@EquivalentAmount,
              equivalentCurrency: charge.@EquivalentCurrency,
              firstPiece: charge.@FirstPiece,
              lastPiece: charge.@LastPiece,
              noChargeNotAvailable: charge.@NoChargeNotAvailable
            }),
            provisionType: baggageInformation.@ProvisionType,
            segment: baggageInformation.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
              id: segment.@Id
            })
          })
        },
        commissionData: {
          cat35CommissionAmount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionAmount,
          cat35CommissionPercentage: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionPercentage,
          cat35MarkupAmount: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35MarkupAmount,
          commissionAmountInEquivalent: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionAmountInEquivalent,
          commissionSource: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionSource,
          vccInformation: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.*ns0#VCCInformation default [] map ((vCCInformation, indexOfVCCInformation) -> {
            commissionAmount: vCCInformation.@CommissionAmount,
            commissionContractQualifier: vCCInformation.@CommissionContractQualifier,
            commissionPercent: vCCInformation.@CommissionPercent,
            earnedCommissionAmount: vCCInformation.@EarnedCommissionAmount,
            fareComponentBreakdown: vCCInformation.*ns0#FareComponentBreakdown default [] map ((fareComponentBreakdown, indexOfFareComponentBreakdown) -> {
              contractFamilyId: fareComponentBreakdown.@ContractFamilyID,
              contractId: fareComponentBreakdown.@ContractID,
              earnedFareComponentCommission: fareComponentBreakdown.@EarnedFareComponentCommission,
              fareComponentCommission: fareComponentBreakdown.@FareComponentCommission,
              fareComponentReferenceId: fareComponentBreakdown.@FareComponentReferenceID,
              methodId: fareComponentBreakdown.@MethodID,
              ruleFamilyId: fareComponentBreakdown.@RuleFamilyID,
              ruleId: fareComponentBreakdown.@RuleID
            }),
            totalAmountIncludingMarkUp: vCCInformation.@TotalAmountIncludingMarkUp,
            validatingCarrier: vCCInformation.@ValidatingCarrier
          })
        },
        fareComponents: {
          fareComponent: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#FareComponents.*ns0#FareComponent default [] map ((fareComponent, indexOfFareComponent) -> {
            baseFare: {
              amount: fareComponent.ns0#BaseFare.@Amount,
              currencyCode: fareComponent.ns0#BaseFare.@CurrencyCode,
              decimalPlaces: fareComponent.ns0#BaseFare.@DecimalPlaces
            },
            brandFeatureRef: fareComponent.*ns0#BrandFeatureRef default [] map ((brandFeatureRef, indexOfBrandFeatureRef) -> {
              featureId: brandFeatureRef.@FeatureId
            }),
            brandId: fareComponent.@BrandID,
            brandName: fareComponent.@BrandName,
            equivFare: {
              amount: fareComponent.ns0#EquivFare.@Amount,
              currencyCode: fareComponent.ns0#EquivFare.@CurrencyCode,
              decimalPlaces: fareComponent.ns0#EquivFare.@DecimalPlaces,
              effectivePriceDeviation: fareComponent.ns0#EquivFare.@EffectivePriceDeviation
            },
            fareRetailerRule: fareComponent.*ns0#FareRetailerRule default [] map ((fareRetailerRule, indexOfFareRetailerRule) -> {
              code: fareRetailerRule.@Code,
              transactionType: fareRetailerRule.@TransactionType
            }),
            handlingMarkupDetail: fareComponent.*ns0#HandlingMarkupDetail default [] map ((handlingMarkupDetail, indexOfHandlingMarkupDetail) -> {
              amountCurrency: handlingMarkupDetail.@AmountCurrency,
              fareAmountAfterMarkup: handlingMarkupDetail.@FareAmountAfterMarkup,
              markupAmount: handlingMarkupDetail.@MarkupAmount,
              markupHandlingFeeAppId: handlingMarkupDetail.@MarkupHandlingFeeAppID,
              markupRuleItemNumber: handlingMarkupDetail.@MarkupRuleItemNumber,
              markupRuleSourcePcc: handlingMarkupDetail.@MarkupRuleSourcePCC,
              markupTypeCode: handlingMarkupDetail.@MarkupTypeCode,
              retailerRuleQualifier: handlingMarkupDetail.@RetailerRuleQualifier
            }),
            pointsRedemption: {
              baseFareConversionRate: fareComponent.ns0#PointsRedemption.@BaseFareConversionRate,
              baseFarePoints: fareComponent.ns0#PointsRedemption.@BaseFarePoints,
              minimumPoints: fareComponent.ns0#PointsRedemption.@MinimumPoints,
              surchargesConversionRate: fareComponent.ns0#PointsRedemption.@SurchargesConversionRate,
              taxConversionRate: fareComponent.ns0#PointsRedemption.@TaxConversionRate,
              totalPoints: fareComponent.ns0#PointsRedemption.@TotalPoints,
              totalSurcharges: fareComponent.ns0#PointsRedemption.@TotalSurcharges,
              totalTaxes: fareComponent.ns0#PointsRedemption.@TotalTaxes
            },
            programCode: fareComponent.@ProgramCode,
            programDescription: fareComponent.@ProgramDescription,
            programId: fareComponent.@ProgramID,
            programSystemCode: fareComponent.@ProgramSystemCode,
            segment: fareComponent.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
              flightIndex: segment.@FlightIndex,
              legIndex: segment.@LegIndex
            }),
            taxes: {
              tax: {
                amount: fareComponent.ns0#Taxes.ns0#Tax.@Amount,
                applyToReissue: fareComponent.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                carrierCode: fareComponent.ns0#Taxes.ns0#Tax.@CarrierCode,
                countryCode: fareComponent.ns0#Taxes.ns0#Tax.@CountryCode,
                currencyCode: fareComponent.ns0#Taxes.ns0#Tax.@CurrencyCode,
                decimalPlaces: fareComponent.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                maxAmount: fareComponent.ns0#Taxes.ns0#Tax.@MaxAmount,
                minAmount: fareComponent.ns0#Taxes.ns0#Tax.@MinAmount,
                minMaxCurrency: fareComponent.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                pointsAmount: fareComponent.ns0#Taxes.ns0#Tax.@PointsAmount,
                publishedAmount: fareComponent.ns0#Taxes.ns0#Tax.@PublishedAmount,
                publishedCurrency: fareComponent.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                rateUsed: fareComponent.ns0#Taxes.ns0#Tax.@RateUsed,
                refundable: fareComponent.ns0#Taxes.ns0#Tax.@Refundable,
                reissueCurrency: fareComponent.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                reissueMaxAmount: fareComponent.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                reissueRestrictionApplies: fareComponent.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                reissueTaxRefundable: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                reissueTaxType: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                stationCode: fareComponent.ns0#Taxes.ns0#Tax.@StationCode,
                taxCode: fareComponent.ns0#Taxes.ns0#Tax.@TaxCode,
                taxOnChangeFee: fareComponent.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
              }
            },
            totalFare: {
              amount: fareComponent.ns0#TotalFare.@Amount,
              currencyCode: fareComponent.ns0#TotalFare.@CurrencyCode,
              decimalPlaces: fareComponent.ns0#TotalFare.@DecimalPlaces
            }
          })
        },
        legs: {
          leg: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg default [] map ((leg, indexOfLeg) -> {
            baseFare: {
              amount: leg.ns0#BaseFare.@Amount,
              currencyCode: leg.ns0#BaseFare.@CurrencyCode,
              decimalPlaces: leg.ns0#BaseFare.@DecimalPlaces
            },
            equivFare: {
              amount: leg.ns0#EquivFare.@Amount,
              currencyCode: leg.ns0#EquivFare.@CurrencyCode,
              decimalPlaces: leg.ns0#EquivFare.@DecimalPlaces,
              effectivePriceDeviation: leg.ns0#EquivFare.@EffectivePriceDeviation
            },
            fareStatus: leg.@FareStatus,
            number: leg.@Number,
            pointsRedemption: {
              baseFareConversionRate: leg.ns0#PointsRedemption.@BaseFareConversionRate,
              baseFarePoints: leg.ns0#PointsRedemption.@BaseFarePoints,
              minimumPoints: leg.ns0#PointsRedemption.@MinimumPoints,
              surchargesConversionRate: leg.ns0#PointsRedemption.@SurchargesConversionRate,
              taxConversionRate: leg.ns0#PointsRedemption.@TaxConversionRate,
              totalPoints: leg.ns0#PointsRedemption.@TotalPoints,
              totalSurcharges: leg.ns0#PointsRedemption.@TotalSurcharges,
              totalTaxes: leg.ns0#PointsRedemption.@TotalTaxes
            },
            taxes: {
              tax: {
                amount: leg.ns0#Taxes.ns0#Tax.@Amount,
                applyToReissue: leg.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                carrierCode: leg.ns0#Taxes.ns0#Tax.@CarrierCode,
                countryCode: leg.ns0#Taxes.ns0#Tax.@CountryCode,
                currencyCode: leg.ns0#Taxes.ns0#Tax.@CurrencyCode,
                decimalPlaces: leg.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                maxAmount: leg.ns0#Taxes.ns0#Tax.@MaxAmount,
                minAmount: leg.ns0#Taxes.ns0#Tax.@MinAmount,
                minMaxCurrency: leg.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                pointsAmount: leg.ns0#Taxes.ns0#Tax.@PointsAmount,
                publishedAmount: leg.ns0#Taxes.ns0#Tax.@PublishedAmount,
                publishedCurrency: leg.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                rateUsed: leg.ns0#Taxes.ns0#Tax.@RateUsed,
                refundable: leg.ns0#Taxes.ns0#Tax.@Refundable,
                reissueCurrency: leg.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                reissueMaxAmount: leg.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                reissueRestrictionApplies: leg.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                reissueTaxRefundable: leg.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                reissueTaxType: leg.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                stationCode: leg.ns0#Taxes.ns0#Tax.@StationCode,
                taxCode: leg.ns0#Taxes.ns0#Tax.@TaxCode,
                taxOnChangeFee: leg.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
              }
            },
            totalFare: {
              amount: leg.ns0#TotalFare.@Amount,
              currencyCode: leg.ns0#TotalFare.@CurrencyCode,
              decimalPlaces: leg.ns0#TotalFare.@DecimalPlaces
            },
            totalMileage: {
              amount: leg.ns0#TotalMileage.@Amount
            }
          })
        },
        messages: {
          message: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#Messages.*ns0#Message default [] map ((message, indexOfMessage) -> {
            airlineCode: message.@AirlineCode,
            failCode: message.@FailCode,
            info: message.@Info,
            "type": message.@Type
          })
        },
        pointsRedemption: {
          baseFareConversionRate: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFareConversionRate,
          baseFarePoints: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFarePoints,
          minimumPoints: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@MinimumPoints,
          surchargesConversionRate: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@SurchargesConversionRate,
          taxConversionRate: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TaxConversionRate,
          totalPoints: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalPoints,
          totalSurcharges: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalSurcharges,
          totalTaxes: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalTaxes
        },
        sellingFareDataList: {
          sellingFareData: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#SellingFareDataList.*ns0#SellingFareData default [] map ((sellingFareDatum, indexOfSellingFareDatum) -> {
            baseFareAmount: sellingFareDatum.@BaseFareAmount,
            constructedTotalAmount: sellingFareDatum.@ConstructedTotalAmount,
            equivalentAmount: sellingFareDatum.@EquivalentAmount,
            fareCalculation: sellingFareDatum.@FareCalculation,
            handlingMarkupSummary: sellingFareDatum.*ns0#HandlingMarkupSummary default [] map ((handlingMarkupSummary, indexOfHandlingMarkupSummary) -> {
              description: handlingMarkupSummary.@Description,
              monetaryAmountValue: handlingMarkupSummary.@MonetaryAmountValue,
              typeCode: handlingMarkupSummary.@TypeCode
            }),
            layerTypeName: sellingFareDatum.@LayerTypeName,
            tax: sellingFareDatum.*ns0#Tax default [] map ((tax, indexOfTax) -> {
              amount: tax.@Amount,
              applyToReissue: tax.@ApplyToReissue,
              carrierCode: tax.@CarrierCode,
              countryCode: tax.@CountryCode,
              currencyCode: tax.@CurrencyCode,
              decimalPlaces: tax.@DecimalPlaces,
              maxAmount: tax.@MaxAmount,
              minAmount: tax.@MinAmount,
              minMaxCurrency: tax.@MinMaxCurrency,
              pointsAmount: tax.@PointsAmount,
              publishedAmount: tax.@PublishedAmount,
              publishedCurrency: tax.@PublishedCurrency,
              rateUsed: tax.@RateUsed,
              refundable: tax.@Refundable,
              reissueCurrency: tax.@ReissueCurrency,
              reissueMaxAmount: tax.@ReissueMaxAmount,
              reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
              reissueTaxRefundable: tax.@ReissueTaxRefundable,
              reissueTaxType: tax.@ReissueTaxType,
              stationCode: tax.@StationCode,
              taxCode: tax.@TaxCode,
              taxOnChangeFee: tax.@TaxOnChangeFee
            }),
            taxSummary: sellingFareDatum.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
              amount: taxSummary.@Amount,
              countryCode: taxSummary.@CountryCode,
              currencyCode: taxSummary.@CurrencyCode,
              decimalPlaces: taxSummary.@DecimalPlaces,
              pointsAmount: taxSummary.@PointsAmount,
              publishedAmount: taxSummary.@PublishedAmount,
              publishedCurrency: taxSummary.@PublishedCurrency,
              stationCode: taxSummary.@StationCode,
              taxCode: taxSummary.@TaxCode
            }),
            totalPerPassenger: sellingFareDatum.@TotalPerPassenger,
            totalTaxes: sellingFareDatum.@TotalTaxes
          })
        },
        surcharges: airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".*ns0#Surcharges default [] map ((surcharge, indexOfSurcharge) -> {
          ind: surcharge.@Ind,
          "type": surcharge.@Type,
          amount: surcharge
        })
      }) if airItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions"?
    },
    lastTicketDate: airItineraryPricingInfo.@LastTicketDate,
    previousExchangeDate: airItineraryPricingInfo.@PreviousExchangeDate,
    pricingSource: airItineraryPricingInfo.@PricingSource,
    pricingSubSource: airItineraryPricingInfo.@PricingSubSource,
    privateFareType: airItineraryPricingInfo.@PrivateFareType,
    pseudoCityCode: airItineraryPricingInfo.@PseudoCityCode,
    ptcFareBreakdowns: {
      ptcFareBreakdown: airItineraryPricingInfo.ns0#"PTC_FareBreakdowns".*ns0#"PTC_FareBreakdown" default [] map ((pTCFareBreakdown, indexOfPTCFareBreakdown) -> {
        endorsements: {
          (endorsement: pTCFareBreakdown.ns0#Endorsements.*ns0#Endorsement default [] map ((endorsement, indexOfEndorsement) -> {
            language: endorsement.@Language
          })) if pTCFareBreakdown.ns0#Endorsements.*ns0#Endorsement?,
          nonEndorsableIndicator: pTCFareBreakdown.ns0#Endorsements.@NonEndorsableIndicator,
          nonRefundableIndicator: pTCFareBreakdown.ns0#Endorsements.@NonRefundableIndicator,
          tpaExtensions: pTCFareBreakdown.ns0#Endorsements.ns0#"TPA_Extensions"
        },
        fareBasisCodes: {
          fareBasisCode: pTCFareBreakdown.ns0#FareBasisCodes.*ns0#FareBasisCode default [] map ((fareBasisCode, indexOfFareBasisCode) -> {
            accountCode: fareBasisCode.@AccountCode,
            arrivalAirportCode: fareBasisCode.@ArrivalAirportCode,
            availabilityBreak: fareBasisCode.@AvailabilityBreak,
            bookingCode: fareBasisCode.@BookingCode,
            departureAirportCode: fareBasisCode.@DepartureAirportCode,
            fareCode: fareBasisCode,
            fareComponentBeginAirport: fareBasisCode.@FareComponentBeginAirport,
            fareComponentDirectionality: fareBasisCode.@FareComponentDirectionality,
            fareComponentEndAirport: fareBasisCode.@FareComponentEndAirport,
            fareComponentReferenceId: fareBasisCode.@FareComponentReferenceID,
            fareComponentVendorCode: fareBasisCode.@FareComponentVendorCode,
            govCarrier: fareBasisCode.@GovCarrier,
            mileage: fareBasisCode.@Mileage,
            privateFareType: fareBasisCode.@PrivateFareType
          })
        },
        fareInfos: {
          fareInfo: pTCFareBreakdown.ns0#FareInfos.*ns0#FareInfo default [] map ((fareInfo, indexOfFareInfo) -> mapFareInfo(fareInfo))
        },
        lastTicketDate: pTCFareBreakdown.@LastTicketDate,
        passengerFare: {
          baseFare: {
            amount: pTCFareBreakdown.ns0#PassengerFare.ns0#BaseFare.@Amount,
            currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#BaseFare.@CurrencyCode,
            decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#BaseFare.@DecimalPlaces
          },
          (currencyConversions: {
            conversion: pTCFareBreakdown.ns0#PassengerFare.ns0#CurrencyConversions.*ns0#Conversion default [] map ((conversion, indexOfConversion) -> {
              from: conversion.@From,
              rateOfExchange: conversion.@RateOfExchange,
              to: conversion.@To
            })
          }) if pTCFareBreakdown.ns0#PassengerFare.ns0#CurrencyConversions.*ns0#Conversion?,
          equivFare: {
            amount: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@Amount,
            currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@CurrencyCode,
            decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@DecimalPlaces,
            effectiveDeviationType: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@EffectiveDeviationType,
            effectivePriceDeviation: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@EffectivePriceDeviation
          },
          fareConstruction: {
            amount: pTCFareBreakdown.ns0#PassengerFare.ns0#FareConstruction.@Amount,
            currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#FareConstruction.@CurrencyCode,
            decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#FareConstruction.@DecimalPlaces
          },
          (fees: {
            fee: pTCFareBreakdown.ns0#PassengerFare.ns0#Fees.*ns0#Fee default [] map ((fee, indexOfFee) -> {
              amount: fee.@Amount,
              currencyCode: fee.@CurrencyCode,
              decimalPlaces: fee.@DecimalPlaces,
              feeCode: fee.@FeeCode
            })
          }) if pTCFareBreakdown.ns0#PassengerFare.ns0#Fees.*ns0#Fee?,
          negotiatedFare: pTCFareBreakdown.ns0#PassengerFare.@NegotiatedFare,
          negotiatedFareCode: pTCFareBreakdown.ns0#PassengerFare.@NegotiatedFareCode,
          (nonRefundableBaseFare: {
            amount: pTCFareBreakdown.ns0#PassengerFare.ns0#NonRefundableBaseFare.@Amount,
            currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#NonRefundableBaseFare.@CurrencyCode,
            decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#NonRefundableBaseFare.@DecimalPlaces
          }) if pTCFareBreakdown.ns0#PassengerFare.ns0#NonRefundableBaseFare?,
          (obFees: {
            obFee: pTCFareBreakdown.ns0#PassengerFare.ns0#OBFees.*ns0#OBFee default [] map ((oBFee, indexOfOBFee) -> {
              amount: oBFee.@Amount,
              currencyCode: oBFee.@CurrencyCode,
              decimalPlaces: oBFee.@DecimalPlaces,
              description: oBFee.@Description,
              "type": oBFee.@Type
            }),
            tTypeAmount: pTCFareBreakdown.ns0#PassengerFare.ns0#OBFees.@TTypeAmount
          }) if pTCFareBreakdown.ns0#PassengerFare.ns0#OBFees.*ns0#OBFee?,
          (penaltiesInfo: {
            penalty: pTCFareBreakdown.ns0#PassengerFare.ns0#PenaltiesInfo.*ns0#Penalty default [] map ((penalty, indexOfPenalty) -> {
              amount: penalty.@Amount,
              applicability: penalty.@Applicability,
              cat16Info: penalty.@Cat16Info,
              cat16TextOnly: penalty.*ns0#Cat16TextOnly default [] map ((cat16TextOnly, indexOfCat16TextOnly) -> {
                fareBasisCode: cat16TextOnly.@FareBasisCode,
                fareComponentId: cat16TextOnly.@FareComponentID
              }),
              changeable: penalty.@Changeable,
              conditionsApply: penalty.@ConditionsApply,
              currencyCode: penalty.@CurrencyCode,
              decimalPlaces: penalty.@DecimalPlaces,
              refundable: penalty.@Refundable,
              "type": penalty.@Type
            })
          }) if pTCFareBreakdown.ns0#PassengerFare.ns0#PenaltiesInfo.*ns0#Penalty?,
          (rateOfExchange: {
            value: pTCFareBreakdown.ns0#PassengerFare.ns0#RateOfExchange.@Value
          }) if pTCFareBreakdown.ns0#PassengerFare.ns0#RateOfExchange?,
          (reissueInfoList: {
            reissueInfo: pTCFareBreakdown.ns0#PassengerFare.ns0#ReissueInfoList.*ns0#ReissueInfo default [] map ((reissueInfo, indexOfReissueInfo) -> {
              changeFees: {
                changeFee: {
                  amount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@Amount,
                  changeFeeNotApplicable: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeNotApplicable,
                  changeFeeWaived: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeWaived,
                  currencyCode: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@CurrencyCode,
                  decimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@DecimalPlaces,
                  highestChangeFee: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@HighestChangeFee,
                  paymentAmount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentAmount,
                  paymentCurrency: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentCurrency,
                  paymentDecimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentDecimalPlaces
                }
              },
              formOfRefund: reissueInfo.@FormOfRefund,
              reissueDoesNotAllowElectronicTicket: reissueInfo.@ReissueDoesNotAllowElectronicTicket,
              reissueRequiresElectronicTicket: reissueInfo.@ReissueRequiresElectronicTicket,
              reissueResultFromTag: reissueInfo.@ReissueResultFromTag,
              residualIdicator: reissueInfo.@ResidualIdicator,
              taxRefundable: reissueInfo.@TaxRefundable,
              typeOfReissueTransaction: reissueInfo.@TypeOfReissueTransaction,
              typeOfServiceFee: reissueInfo.@TypeOfServiceFee
            })
          }) if pTCFareBreakdown.ns0#PassengerFare.ns0#ReissueInfoList.*ns0#ReissueInfo?,
          taxes: {
            (fareComponentsTaxes: {
              fareComponentTaxes: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#FareComponentsTaxes.*ns0#FareComponentTaxes default [] map ((fareComponentTaxis, indexOfFareComponentTaxis) -> {
                flightSegment: fareComponentTaxis.*ns0#FlightSegment default [] map ((flightSegment, indexOfFlightSegment) -> {
                  arrivalAirportCode: flightSegment.@ArrivalAirportCode,
                  departureAirportCode: flightSegment.@DepartureAirportCode
                }),
                tax: fareComponentTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                  amount: tax.@Amount,
                  applyToReissue: tax.@ApplyToReissue,
                  carrierCode: tax.@CarrierCode,
                  countryCode: tax.@CountryCode,
                  currencyCode: tax.@CurrencyCode,
                  decimalPlaces: tax.@DecimalPlaces,
                  maxAmount: tax.@MaxAmount,
                  minAmount: tax.@MinAmount,
                  minMaxCurrency: tax.@MinMaxCurrency,
                  pointsAmount: tax.@PointsAmount,
                  publishedAmount: tax.@PublishedAmount,
                  publishedCurrency: tax.@PublishedCurrency,
                  rateUsed: tax.@RateUsed,
                  refundable: tax.@Refundable,
                  reissueCurrency: tax.@ReissueCurrency,
                  reissueMaxAmount: tax.@ReissueMaxAmount,
                  reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                  reissueTaxRefundable: tax.@ReissueTaxRefundable,
                  reissueTaxType: tax.@ReissueTaxType,
                  stationCode: tax.@StationCode,
                  taxCode: tax.@TaxCode,
                  taxOnChangeFee: tax.@TaxOnChangeFee
                }),
                taxSummary: fareComponentTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                  amount: taxSummary.@Amount,
                  countryCode: taxSummary.@CountryCode,
                  currencyCode: taxSummary.@CurrencyCode,
                  decimalPlaces: taxSummary.@DecimalPlaces,
                  pointsAmount: taxSummary.@PointsAmount,
                  publishedAmount: taxSummary.@PublishedAmount,
                  publishedCurrency: taxSummary.@PublishedCurrency,
                  stationCode: taxSummary.@StationCode,
                  taxCode: taxSummary.@TaxCode
                })
              })
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#FareComponentsTaxes.*ns0#FareComponentTaxes?,
            (legsTaxes: {
              legTaxes: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#LegsTaxes.*ns0#LegTaxes default [] map ((legTaxis, indexOfLegTaxis) -> {
                number: legTaxis.@Number,
                tax: legTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                  amount: tax.@Amount,
                  applyToReissue: tax.@ApplyToReissue,
                  carrierCode: tax.@CarrierCode,
                  countryCode: tax.@CountryCode,
                  currencyCode: tax.@CurrencyCode,
                  decimalPlaces: tax.@DecimalPlaces,
                  maxAmount: tax.@MaxAmount,
                  minAmount: tax.@MinAmount,
                  minMaxCurrency: tax.@MinMaxCurrency,
                  pointsAmount: tax.@PointsAmount,
                  publishedAmount: tax.@PublishedAmount,
                  publishedCurrency: tax.@PublishedCurrency,
                  rateUsed: tax.@RateUsed,
                  refundable: tax.@Refundable,
                  reissueCurrency: tax.@ReissueCurrency,
                  reissueMaxAmount: tax.@ReissueMaxAmount,
                  reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                  reissueTaxRefundable: tax.@ReissueTaxRefundable,
                  reissueTaxType: tax.@ReissueTaxType,
                  stationCode: tax.@StationCode,
                  taxCode: tax.@TaxCode,
                  taxOnChangeFee: tax.@TaxOnChangeFee
                }),
                taxSummary: legTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                  amount: taxSummary.@Amount,
                  countryCode: taxSummary.@CountryCode,
                  currencyCode: taxSummary.@CurrencyCode,
                  decimalPlaces: taxSummary.@DecimalPlaces,
                  pointsAmount: taxSummary.@PointsAmount,
                  publishedAmount: taxSummary.@PublishedAmount,
                  publishedCurrency: taxSummary.@PublishedCurrency,
                  stationCode: taxSummary.@StationCode,
                  taxCode: taxSummary.@TaxCode
                })
              })
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#LegsTaxes.*ns0#LegTaxes?,
            tax: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.*ns0#Tax default [] map ((tax, indexOfTax) -> {
              amount: tax.@Amount,
              applyToReissue: tax.@ApplyToReissue,
              carrierCode: tax.@CarrierCode,
              countryCode: tax.@CountryCode,
              currencyCode: tax.@CurrencyCode,
              decimalPlaces: tax.@DecimalPlaces,
              maxAmount: tax.@MaxAmount,
              minAmount: tax.@MinAmount,
              minMaxCurrency: tax.@MinMaxCurrency,
              pointsAmount: tax.@PointsAmount,
              publishedAmount: tax.@PublishedAmount,
              publishedCurrency: tax.@PublishedCurrency,
              rateUsed: tax.@RateUsed,
              refundable: tax.@Refundable,
              reissueCurrency: tax.@ReissueCurrency,
              reissueMaxAmount: tax.@ReissueMaxAmount,
              reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
              reissueTaxRefundable: tax.@ReissueTaxRefundable,
              reissueTaxType: tax.@ReissueTaxType,
              stationCode: tax.@StationCode,
              taxCode: tax.@TaxCode,
              taxOnChangeFee: tax.@TaxOnChangeFee
            }),
            taxSummary: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
              amount: taxSummary.@Amount,
              countryCode: taxSummary.@CountryCode,
              currencyCode: taxSummary.@CurrencyCode,
              decimalPlaces: taxSummary.@DecimalPlaces,
              pointsAmount: taxSummary.@PointsAmount,
              publishedAmount: taxSummary.@PublishedAmount,
              publishedCurrency: taxSummary.@PublishedCurrency,
              stationCode: taxSummary.@StationCode,
              taxCode: taxSummary.@TaxCode
            }),
            totalTax: {
              amount: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#TotalTax.@Amount,
              currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#TotalTax.@CurrencyCode,
              decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#TotalTax.@DecimalPlaces
            }
          },
          totalFare: {
            amount: pTCFareBreakdown.ns0#PassengerFare.ns0#TotalFare.@Amount,
            currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#TotalFare.@CurrencyCode,
            decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#TotalFare.@DecimalPlaces
          },
          tpaExtensions: {
            (baggageInformationList: {
              baggageInformation: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#BaggageInformationList.*ns0#BaggageInformation default [] map ((baggageInformation, indexOfBaggageInformation) -> {
                airlineCode: baggageInformation.@AirlineCode,
                allowance: baggageInformation.*ns0#Allowance default [] map ((allowance, indexOfAllowance) -> {
                  description1: allowance.@Description1,
                  description2: allowance.@Description2,
                  pieces: allowance.@Pieces,
                  unit: allowance.@Unit,
                  weight: allowance.@Weight
                }),
                charge: baggageInformation.*ns0#Charge default [] map ((charge, indexOfCharge) -> {
                  description1: charge.@Description1,
                  description2: charge.@Description2,
                  equivalentAmount: charge.@EquivalentAmount,
                  equivalentCurrency: charge.@EquivalentCurrency,
                  firstPiece: charge.@FirstPiece,
                  lastPiece: charge.@LastPiece,
                  noChargeNotAvailable: charge.@NoChargeNotAvailable
                }),
                provisionType: baggageInformation.@ProvisionType,
                segment: baggageInformation.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
                  id: segment.@Id
                })
              })
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#BaggageInformationList.*ns0#BaggageInformation?,
            (commissionData: {
              cat35CommissionAmount: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionAmount,
              cat35CommissionPercentage: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionPercentage,
              cat35MarkupAmount: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35MarkupAmount,
              commissionAmountInEquivalent: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionAmountInEquivalent,
              commissionSource: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionSource,
              vccInformation: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.*ns0#VCCInformation default [] map ((vCCInformation, indexOfVCCInformation) -> {
                commissionAmount: vCCInformation.@CommissionAmount,
                commissionContractQualifier: vCCInformation.@CommissionContractQualifier,
                commissionPercent: vCCInformation.@CommissionPercent,
                earnedCommissionAmount: vCCInformation.@EarnedCommissionAmount,
                fareComponentBreakdown: vCCInformation.*ns0#FareComponentBreakdown default [] map ((fareComponentBreakdown, indexOfFareComponentBreakdown) -> {
                  contractFamilyId: fareComponentBreakdown.@ContractFamilyID,
                  contractId: fareComponentBreakdown.@ContractID,
                  earnedFareComponentCommission: fareComponentBreakdown.@EarnedFareComponentCommission,
                  fareComponentCommission: fareComponentBreakdown.@FareComponentCommission,
                  fareComponentReferenceId: fareComponentBreakdown.@FareComponentReferenceID,
                  methodId: fareComponentBreakdown.@MethodID,
                  ruleFamilyId: fareComponentBreakdown.@RuleFamilyID,
                  ruleId: fareComponentBreakdown.@RuleID
                }),
                totalAmountIncludingMarkUp: vCCInformation.@TotalAmountIncludingMarkUp,
                validatingCarrier: vCCInformation.@ValidatingCarrier
              })
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData?,
            (fareComponents: {
              fareComponent: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#FareComponents.*ns0#FareComponent default [] map ((fareComponent, indexOfFareComponent) -> {
                baseFare: {
                  amount: fareComponent.ns0#BaseFare.@Amount,
                  currencyCode: fareComponent.ns0#BaseFare.@CurrencyCode,
                  decimalPlaces: fareComponent.ns0#BaseFare.@DecimalPlaces
                },
                (brandFeatureRef: fareComponent.*ns0#BrandFeatureRef default [] map ((brandFeatureRef, indexOfBrandFeatureRef) -> {
                  featureId: brandFeatureRef.@FeatureId
                })) if fareComponent.*ns0#BrandFeatureRef?,
                brandId: fareComponent.@BrandID,
                brandName: fareComponent.@BrandName,
                equivFare: {
                  amount: fareComponent.ns0#EquivFare.@Amount,
                  currencyCode: fareComponent.ns0#EquivFare.@CurrencyCode,
                  decimalPlaces: fareComponent.ns0#EquivFare.@DecimalPlaces,
                  effectivePriceDeviation: fareComponent.ns0#EquivFare.@EffectivePriceDeviation
                },
                (fareRetailerRule: fareComponent.*ns0#FareRetailerRule default [] map ((fareRetailerRule, indexOfFareRetailerRule) -> {
                  code: fareRetailerRule.@Code,
                  transactionType: fareRetailerRule.@TransactionType
                })) if fareComponent.*ns0#FareRetailerRule?,
                (handlingMarkupDetail: fareComponent.*ns0#HandlingMarkupDetail default [] map ((handlingMarkupDetail, indexOfHandlingMarkupDetail) -> {
                  amountCurrency: handlingMarkupDetail.@AmountCurrency,
                  fareAmountAfterMarkup: handlingMarkupDetail.@FareAmountAfterMarkup,
                  markupAmount: handlingMarkupDetail.@MarkupAmount,
                  markupHandlingFeeAppId: handlingMarkupDetail.@MarkupHandlingFeeAppID,
                  markupRuleItemNumber: handlingMarkupDetail.@MarkupRuleItemNumber,
                  markupRuleSourcePcc: handlingMarkupDetail.@MarkupRuleSourcePCC,
                  markupTypeCode: handlingMarkupDetail.@MarkupTypeCode,
                  retailerRuleQualifier: handlingMarkupDetail.@RetailerRuleQualifier
                })) if fareComponent.*ns0#HandlingMarkupDetail?,
                (pointsRedemption: {
                  baseFareConversionRate: fareComponent.ns0#PointsRedemption.@BaseFareConversionRate,
                  baseFarePoints: fareComponent.ns0#PointsRedemption.@BaseFarePoints,
                  minimumPoints: fareComponent.ns0#PointsRedemption.@MinimumPoints,
                  surchargesConversionRate: fareComponent.ns0#PointsRedemption.@SurchargesConversionRate,
                  taxConversionRate: fareComponent.ns0#PointsRedemption.@TaxConversionRate,
                  totalPoints: fareComponent.ns0#PointsRedemption.@TotalPoints,
                  totalSurcharges: fareComponent.ns0#PointsRedemption.@TotalSurcharges,
                  totalTaxes: fareComponent.ns0#PointsRedemption.@TotalTaxes
                }) if fareComponent.ns0#PointsRedemption?,
                programCode: fareComponent.@ProgramCode,
                programDescription: fareComponent.@ProgramDescription,
                programId: fareComponent.@ProgramID,
                programSystemCode: fareComponent.@ProgramSystemCode,
                segment: fareComponent.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
                  flightIndex: segment.@FlightIndex,
                  legIndex: segment.@LegIndex
                }),
                taxes: {
                  tax: {
                    amount: fareComponent.ns0#Taxes.ns0#Tax.@Amount,
                    applyToReissue: fareComponent.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                    carrierCode: fareComponent.ns0#Taxes.ns0#Tax.@CarrierCode,
                    countryCode: fareComponent.ns0#Taxes.ns0#Tax.@CountryCode,
                    currencyCode: fareComponent.ns0#Taxes.ns0#Tax.@CurrencyCode,
                    decimalPlaces: fareComponent.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                    maxAmount: fareComponent.ns0#Taxes.ns0#Tax.@MaxAmount,
                    minAmount: fareComponent.ns0#Taxes.ns0#Tax.@MinAmount,
                    minMaxCurrency: fareComponent.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                    pointsAmount: fareComponent.ns0#Taxes.ns0#Tax.@PointsAmount,
                    publishedAmount: fareComponent.ns0#Taxes.ns0#Tax.@PublishedAmount,
                    publishedCurrency: fareComponent.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                    rateUsed: fareComponent.ns0#Taxes.ns0#Tax.@RateUsed,
                    refundable: fareComponent.ns0#Taxes.ns0#Tax.@Refundable,
                    reissueCurrency: fareComponent.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                    reissueMaxAmount: fareComponent.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                    reissueRestrictionApplies: fareComponent.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                    reissueTaxRefundable: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                    reissueTaxType: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                    stationCode: fareComponent.ns0#Taxes.ns0#Tax.@StationCode,
                    taxCode: fareComponent.ns0#Taxes.ns0#Tax.@TaxCode,
                    taxOnChangeFee: fareComponent.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
                  }
                },
                totalFare: {
                  amount: fareComponent.ns0#TotalFare.@Amount,
                  currencyCode: fareComponent.ns0#TotalFare.@CurrencyCode,
                  decimalPlaces: fareComponent.ns0#TotalFare.@DecimalPlaces
                }
              })
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#FareComponents.*ns0#FareComponent?,
            (legs: {
              leg: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg default [] map ((leg, indexOfLeg) -> {
                baseFare: {
                  amount: leg.ns0#BaseFare.@Amount,
                  currencyCode: leg.ns0#BaseFare.@CurrencyCode,
                  decimalPlaces: leg.ns0#BaseFare.@DecimalPlaces
                },
                equivFare: {
                  amount: leg.ns0#EquivFare.@Amount,
                  currencyCode: leg.ns0#EquivFare.@CurrencyCode,
                  decimalPlaces: leg.ns0#EquivFare.@DecimalPlaces,
                  effectivePriceDeviation: leg.ns0#EquivFare.@EffectivePriceDeviation
                },
                fareStatus: leg.@FareStatus,
                number: leg.@Number,
                pointsRedemption: {
                  baseFareConversionRate: leg.ns0#PointsRedemption.@BaseFareConversionRate,
                  baseFarePoints: leg.ns0#PointsRedemption.@BaseFarePoints,
                  minimumPoints: leg.ns0#PointsRedemption.@MinimumPoints,
                  surchargesConversionRate: leg.ns0#PointsRedemption.@SurchargesConversionRate,
                  taxConversionRate: leg.ns0#PointsRedemption.@TaxConversionRate,
                  totalPoints: leg.ns0#PointsRedemption.@TotalPoints,
                  totalSurcharges: leg.ns0#PointsRedemption.@TotalSurcharges,
                  totalTaxes: leg.ns0#PointsRedemption.@TotalTaxes
                },
                taxes: {
                  tax: {
                    amount: leg.ns0#Taxes.ns0#Tax.@Amount,
                    applyToReissue: leg.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                    carrierCode: leg.ns0#Taxes.ns0#Tax.@CarrierCode,
                    countryCode: leg.ns0#Taxes.ns0#Tax.@CountryCode,
                    currencyCode: leg.ns0#Taxes.ns0#Tax.@CurrencyCode,
                    decimalPlaces: leg.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                    maxAmount: leg.ns0#Taxes.ns0#Tax.@MaxAmount,
                    minAmount: leg.ns0#Taxes.ns0#Tax.@MinAmount,
                    minMaxCurrency: leg.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                    pointsAmount: leg.ns0#Taxes.ns0#Tax.@PointsAmount,
                    publishedAmount: leg.ns0#Taxes.ns0#Tax.@PublishedAmount,
                    publishedCurrency: leg.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                    rateUsed: leg.ns0#Taxes.ns0#Tax.@RateUsed,
                    refundable: leg.ns0#Taxes.ns0#Tax.@Refundable,
                    reissueCurrency: leg.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                    reissueMaxAmount: leg.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                    reissueRestrictionApplies: leg.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                    reissueTaxRefundable: leg.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                    reissueTaxType: leg.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                    stationCode: leg.ns0#Taxes.ns0#Tax.@StationCode,
                    taxCode: leg.ns0#Taxes.ns0#Tax.@TaxCode,
                    taxOnChangeFee: leg.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
                  }
                },
                totalFare: {
                  amount: leg.ns0#TotalFare.@Amount,
                  currencyCode: leg.ns0#TotalFare.@CurrencyCode,
                  decimalPlaces: leg.ns0#TotalFare.@DecimalPlaces
                },
                totalMileage: {
                  amount: leg.ns0#TotalMileage.@Amount
                }
              })
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg?,
            messages: {
              message: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#Messages.*ns0#Message default [] map ((message, indexOfMessage) -> {
                airlineCode: message.@AirlineCode,
                failCode: message.@FailCode,
                info: message.@Info,
                "type": message.@Type
              })
            },
            (pointsRedemption: {
              baseFareConversionRate: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFareConversionRate,
              baseFarePoints: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFarePoints,
              minimumPoints: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@MinimumPoints,
              surchargesConversionRate: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@SurchargesConversionRate,
              taxConversionRate: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TaxConversionRate,
              totalPoints: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalPoints,
              totalSurcharges: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalSurcharges,
              totalTaxes: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalTaxes
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption?,
            (sellingFareDataList: {
              sellingFareData: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#SellingFareDataList.*ns0#SellingFareData default [] map ((sellingFareDatum, indexOfSellingFareDatum) -> {
                baseFareAmount: sellingFareDatum.@BaseFareAmount,
                constructedTotalAmount: sellingFareDatum.@ConstructedTotalAmount,
                equivalentAmount: sellingFareDatum.@EquivalentAmount,
                fareCalculation: sellingFareDatum.@FareCalculation,
                handlingMarkupSummary: sellingFareDatum.*ns0#HandlingMarkupSummary default [] map ((handlingMarkupSummary, indexOfHandlingMarkupSummary) -> {
                  description: handlingMarkupSummary.@Description,
                  monetaryAmountValue: handlingMarkupSummary.@MonetaryAmountValue,
                  typeCode: handlingMarkupSummary.@TypeCode
                }),
                layerTypeName: sellingFareDatum.@LayerTypeName,
                tax: sellingFareDatum.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                  amount: tax.@Amount,
                  applyToReissue: tax.@ApplyToReissue,
                  carrierCode: tax.@CarrierCode,
                  countryCode: tax.@CountryCode,
                  currencyCode: tax.@CurrencyCode,
                  decimalPlaces: tax.@DecimalPlaces,
                  maxAmount: tax.@MaxAmount,
                  minAmount: tax.@MinAmount,
                  minMaxCurrency: tax.@MinMaxCurrency,
                  pointsAmount: tax.@PointsAmount,
                  publishedAmount: tax.@PublishedAmount,
                  publishedCurrency: tax.@PublishedCurrency,
                  rateUsed: tax.@RateUsed,
                  refundable: tax.@Refundable,
                  reissueCurrency: tax.@ReissueCurrency,
                  reissueMaxAmount: tax.@ReissueMaxAmount,
                  reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                  reissueTaxRefundable: tax.@ReissueTaxRefundable,
                  reissueTaxType: tax.@ReissueTaxType,
                  stationCode: tax.@StationCode,
                  taxCode: tax.@TaxCode,
                  taxOnChangeFee: tax.@TaxOnChangeFee
                }),
                taxSummary: sellingFareDatum.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                  amount: taxSummary.@Amount,
                  countryCode: taxSummary.@CountryCode,
                  currencyCode: taxSummary.@CurrencyCode,
                  decimalPlaces: taxSummary.@DecimalPlaces,
                  pointsAmount: taxSummary.@PointsAmount,
                  publishedAmount: taxSummary.@PublishedAmount,
                  publishedCurrency: taxSummary.@PublishedCurrency,
                  stationCode: taxSummary.@StationCode,
                  taxCode: taxSummary.@TaxCode
                }),
                totalPerPassenger: sellingFareDatum.@TotalPerPassenger,
                totalTaxes: sellingFareDatum.@TotalTaxes
              })
            }) if pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#SellingFareDataList.*ns0#SellingFareData?,
            (surcharges: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".*ns0#Surcharges default [] map ((surcharge, indexOfSurcharge) -> {
              ind: surcharge.@Ind,
              "type": surcharge.@Type,
              amount: surcharge
            })) if pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".*ns0#Surcharges?
          }
        },
        passengerTypeQuantity: {
          age: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Age,
          changeable: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Changeable,
          code: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Code,
          codeContext: pTCFareBreakdown.ns0#PassengerTypeQuantity.@CodeContext,
          index: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Index,
          quantity: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Quantity,
          requestedPassengerIndex: pTCFareBreakdown.ns0#PassengerTypeQuantity.@RequestedPassengerIndex,
          (tpaExtensions: {
            age: {
              years: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#Age.@Years
            },
            birthDate: {
              date: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#BirthDate.@Date
            },
            state: {
              code: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#State.@Code
            },
            totalNumber: {
              value: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#TotalNumber.@Value
            },
            voluntaryChanges: {
              match: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#VoluntaryChanges.@Match,
              penalty: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#VoluntaryChanges.*ns0#Penalty default [] map ((penalty, indexOfPenalty) -> {
                amount: penalty.@Amount,
                application: penalty.@Application,
                currencyCode: penalty.@CurrencyCode,
                decimalPlaces: penalty.@DecimalPlaces,
                exclude: penalty.@Exclude,
                "type": penalty.@Type
              })
            }
          }) if pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions"?,
          uri: pTCFareBreakdown.ns0#PassengerTypeQuantity.@URI
        },
        previousExchangeDate: pTCFareBreakdown.@PreviousExchangeDate,
        pricingSource: pTCFareBreakdown.@PricingSource,
        privateFareType: pTCFareBreakdown.@PrivateFareType,
        reissueExchange: pTCFareBreakdown.@ReissueExchange,
        (tpaExtensions: {
          (fareCalcLine: {
            info: pTCFareBreakdown.ns0#"TPA_Extensions".ns0#FareCalcLine.@Info
          }) if pTCFareBreakdown.ns0#"TPA_Extensions".ns0#FareCalcLine?,
          (fareType: {
            name: pTCFareBreakdown.ns0#"TPA_Extensions".ns0#FareType.@Name
          }) if pTCFareBreakdown.ns0#"TPA_Extensions".ns0#FareType?
        }) if pTCFareBreakdown.ns0#"TPA_Extensions"?
      })
    },
    purchaseByDate: airItineraryPricingInfo.@PurchaseByDate,
    reissueExchange: airItineraryPricingInfo.@ReissueExchange,
    repriced: airItineraryPricingInfo.@Repriced,
    spanishFamilyDiscountIndicator: airItineraryPricingInfo.@SpanishFamilyDiscountIndicator,
    (tickets: {
      ticket: airItineraryPricingInfo.ns0#Tickets.*ns0#Ticket default [] map ((ticket, indexOfTicket) -> {
        airItineraryPricingInfo: {
          advancedPurchaseDate: ticket.ns0#AirItineraryPricingInfo.@AdvancedPurchaseDate,
          alternateCityOption: ticket.ns0#AirItineraryPricingInfo.@AlternateCityOption,
          brandId: ticket.ns0#AirItineraryPricingInfo.@BrandID,
          brandsOnAnyMarket: ticket.ns0#AirItineraryPricingInfo.@BrandsOnAnyMarket,
          cachePartition: ticket.ns0#AirItineraryPricingInfo.@CachePartition,
          cachePartitionPriority: ticket.ns0#AirItineraryPricingInfo.@CachePartitionPriority,
          cacheVersion: ticket.ns0#AirItineraryPricingInfo.@CacheVersion,
          cachedItin: ticket.ns0#AirItineraryPricingInfo.@CachedItin,
          fareInfos: {
            fareInfo: ticket.ns0#AirItineraryPricingInfo.ns0#FareInfos.*ns0#FareInfo default [] map ((fareInfo, indexOfFareInfo) -> {
              arrivalAirport: {
                codeContext: fareInfo.ns0#ArrivalAirport.@CodeContext,
                locationCode: fareInfo.ns0#ArrivalAirport.@LocationCode
              },
              departureAirport: {
                codeContext: fareInfo.ns0#DepartureAirport.@CodeContext,
                locationCode: fareInfo.ns0#DepartureAirport.@LocationCode
              },
              departureDate: fareInfo.ns0#DepartureDate,
              fareReference: fareInfo.ns0#FareReference,
              marketingAirline: fareInfo.*ns0#MarketingAirline default [] map ((marketingAirline, indexOfMarketingAirline) -> {
                code: marketingAirline.@Code,
                codeContext: marketingAirline.@CodeContext,
                companyShortName: marketingAirline.@CompanyShortName,
                travelSector: marketingAirline.@TravelSector
              }),
              negotiatedFare: fareInfo.@NegotiatedFare,
              negotiatedFareCode: fareInfo.@NegotiatedFareCode,
              ruleInfo: {
                lengthOfStayRules: {
                  maximumStay: {
                    maxStay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@MaxStay,
                    maxStayDate: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@MaxStayDate,
                    returnTimeOfDay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@ReturnTimeOfDay,
                    returnType: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@ReturnType,
                    stayUnit: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@StayUnit
                  },
                  minimumStay: {
                    minStay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@MinStay,
                    minStayDate: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@MinStayDate,
                    returnTimeOfDay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@ReturnTimeOfDay,
                    stayUnit: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@StayUnit
                  },
                  stayRestrictionsInd: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.@StayRestrictionsInd
                },
                resTicketingRules: {
                  advResTicketing: {
                    advResInd: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.@AdvResInd,
                    advReservation: {
                      latestPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestPeriod,
                      latestTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestTimeOfDay,
                      latestUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestUnit
                    },
                    advTicketing: {
                      fromDepartPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartPeriod,
                      fromDepartTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartTimeOfDay,
                      fromDepartUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartUnit,
                      fromResPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResPeriod,
                      fromResTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResTimeOfDay,
                      fromResUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResUnit
                    },
                    advTicketingInd: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.@AdvTicketingInd
                  }
                }
              },
              tpaExtensions: {
                cabin: {
                  cabin: fareInfo.ns0#"TPA_Extensions".ns0#Cabin.@Cabin
                },
                fareNote: fareInfo.ns0#"TPA_Extensions".*ns0#FareNote default [] map ((fareNote, indexOfFareNote) -> {
                  contentId: fareNote.@ContentID,
                  fareTypeName: fareNote.@FareTypeName,
                  priorityLevel: fareNote.@PriorityLevel
                }),
                meal: {
                  code: fareInfo.ns0#"TPA_Extensions".ns0#Meal.@Code
                },
                rule: fareInfo.ns0#"TPA_Extensions".*ns0#Rule default [] map ((rule, indexOfRule) -> {
                  id: rule.@ID,
                  "type": rule.@Type
                }),
                seatsRemaining: {
                  belowMin: fareInfo.ns0#"TPA_Extensions".ns0#SeatsRemaining.@BelowMin,
                  number: fareInfo.ns0#"TPA_Extensions".ns0#SeatsRemaining.@Number
                }
              }
            })
          },
          fareReturned: ticket.ns0#AirItineraryPricingInfo.@FareReturned,
          fareStatus: ticket.ns0#AirItineraryPricingInfo.@FareStatus,
          flexibleFareId: ticket.ns0#AirItineraryPricingInfo.@FlexibleFareID,
          hoursSinceCreation: ticket.ns0#AirItineraryPricingInfo.@HoursSinceCreation,
          itinTotalFare: {
            baseFare: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#BaseFare.@Amount,
              currencyCode: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#BaseFare.@CurrencyCode,
              decimalPlaces: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#BaseFare.@DecimalPlaces
            },
            currencyConversions: {
              conversion: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#CurrencyConversions.*ns0#Conversion default [] map ((conversion, indexOfConversion) -> {
                from: conversion.@From,
                rateOfExchange: conversion.@RateOfExchange,
                to: conversion.@To
              })
            },
            equivFare: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@Amount,
              currencyCode: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@CurrencyCode,
              decimalPlaces: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@DecimalPlaces,
              effectiveDeviationType: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@EffectiveDeviationType,
              effectivePriceDeviation: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#EquivFare.@EffectivePriceDeviation
            },
            extras: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Extras.@Amount
            },
            fareConstruction: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#FareConstruction.@Amount,
              currencyCode: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#FareConstruction.@CurrencyCode,
              decimalPlaces: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#FareConstruction.@DecimalPlaces
            },
            fees: {
              fee: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Fees.*ns0#Fee default [] map ((fee, indexOfFee) -> {
                amount: fee.@Amount,
                currencyCode: fee.@CurrencyCode,
                decimalPlaces: fee.@DecimalPlaces,
                feeCode: fee.@FeeCode
              })
            },
            negotiatedFare: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.@NegotiatedFare,
            negotiatedFareCode: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.@NegotiatedFareCode,
            nonRefundableBaseFare: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#NonRefundableBaseFare.@Amount,
              currencyCode: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#NonRefundableBaseFare.@CurrencyCode,
              decimalPlaces: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#NonRefundableBaseFare.@DecimalPlaces
            },
            obFees: {
              obFee: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#OBFees.*ns0#OBFee default [] map ((oBFee, indexOfOBFee) -> {
                amount: oBFee.@Amount,
                currencyCode: oBFee.@CurrencyCode,
                decimalPlaces: oBFee.@DecimalPlaces,
                description: oBFee.@Description,
                "type": oBFee.@Type
              }),
              tTypeAmount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#OBFees.@TTypeAmount
            },
            penaltiesInfo: {
              penalty: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#PenaltiesInfo.*ns0#Penalty default [] map ((penalty, indexOfPenalty) -> {
                amount: penalty.@Amount,
                applicability: penalty.@Applicability,
                cat16Info: penalty.@Cat16Info,
                cat16TextOnly: penalty.*ns0#Cat16TextOnly default [] map ((cat16TextOnly, indexOfCat16TextOnly) -> {
                  fareBasisCode: cat16TextOnly.@FareBasisCode,
                  fareComponentId: cat16TextOnly.@FareComponentID
                }),
                changeable: penalty.@Changeable,
                conditionsApply: penalty.@ConditionsApply,
                currencyCode: penalty.@CurrencyCode,
                decimalPlaces: penalty.@DecimalPlaces,
                refundable: penalty.@Refundable,
                "type": penalty.@Type
              })
            },
            rateOfExchange: {
              value: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#RateOfExchange.@Value
            },
            reissueInfoList: {
              reissueInfo: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#ReissueInfoList.*ns0#ReissueInfo default [] map ((reissueInfo, indexOfReissueInfo) -> {
                changeFees: {
                  changeFee: {
                    amount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@Amount,
                    changeFeeNotApplicable: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeNotApplicable,
                    changeFeeWaived: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeWaived,
                    currencyCode: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@CurrencyCode,
                    decimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@DecimalPlaces,
                    highestChangeFee: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@HighestChangeFee,
                    paymentAmount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentAmount,
                    paymentCurrency: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentCurrency,
                    paymentDecimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentDecimalPlaces
                  }
                },
                formOfRefund: reissueInfo.@FormOfRefund,
                reissueDoesNotAllowElectronicTicket: reissueInfo.@ReissueDoesNotAllowElectronicTicket,
                reissueRequiresElectronicTicket: reissueInfo.@ReissueRequiresElectronicTicket,
                reissueResultFromTag: reissueInfo.@ReissueResultFromTag,
                residualIdicator: reissueInfo.@ResidualIdicator,
                taxRefundable: reissueInfo.@TaxRefundable,
                typeOfReissueTransaction: reissueInfo.@TypeOfReissueTransaction,
                typeOfServiceFee: reissueInfo.@TypeOfServiceFee
              })
            },
            serviceFee: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#ServiceFee.@Amount,
              taxAmount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#ServiceFee.@TaxAmount
            },
            taxes: {
              fareComponentsTaxes: {
                fareComponentTaxes: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#FareComponentsTaxes.*ns0#FareComponentTaxes default [] map ((fareComponentTaxis, indexOfFareComponentTaxis) -> {
                  flightSegment: fareComponentTaxis.*ns0#FlightSegment default [] map ((flightSegment, indexOfFlightSegment) -> {
                    arrivalAirportCode: flightSegment.@ArrivalAirportCode,
                    departureAirportCode: flightSegment.@DepartureAirportCode
                  }),
                  tax: fareComponentTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                    amount: tax.@Amount,
                    applyToReissue: tax.@ApplyToReissue,
                    carrierCode: tax.@CarrierCode,
                    countryCode: tax.@CountryCode,
                    currencyCode: tax.@CurrencyCode,
                    decimalPlaces: tax.@DecimalPlaces,
                    maxAmount: tax.@MaxAmount,
                    minAmount: tax.@MinAmount,
                    minMaxCurrency: tax.@MinMaxCurrency,
                    pointsAmount: tax.@PointsAmount,
                    publishedAmount: tax.@PublishedAmount,
                    publishedCurrency: tax.@PublishedCurrency,
                    rateUsed: tax.@RateUsed,
                    refundable: tax.@Refundable,
                    reissueCurrency: tax.@ReissueCurrency,
                    reissueMaxAmount: tax.@ReissueMaxAmount,
                    reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                    reissueTaxRefundable: tax.@ReissueTaxRefundable,
                    reissueTaxType: tax.@ReissueTaxType,
                    stationCode: tax.@StationCode,
                    taxCode: tax.@TaxCode,
                    taxOnChangeFee: tax.@TaxOnChangeFee
                  }),
                  taxSummary: fareComponentTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                    amount: taxSummary.@Amount,
                    countryCode: taxSummary.@CountryCode,
                    currencyCode: taxSummary.@CurrencyCode,
                    decimalPlaces: taxSummary.@DecimalPlaces,
                    pointsAmount: taxSummary.@PointsAmount,
                    publishedAmount: taxSummary.@PublishedAmount,
                    publishedCurrency: taxSummary.@PublishedCurrency,
                    stationCode: taxSummary.@StationCode,
                    taxCode: taxSummary.@TaxCode
                  })
                })
              },
              legsTaxes: {
                legTaxes: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#LegsTaxes.*ns0#LegTaxes default [] map ((legTaxis, indexOfLegTaxis) -> {
                  number: legTaxis.@Number,
                  tax: legTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                    amount: tax.@Amount,
                    applyToReissue: tax.@ApplyToReissue,
                    carrierCode: tax.@CarrierCode,
                    countryCode: tax.@CountryCode,
                    currencyCode: tax.@CurrencyCode,
                    decimalPlaces: tax.@DecimalPlaces,
                    maxAmount: tax.@MaxAmount,
                    minAmount: tax.@MinAmount,
                    minMaxCurrency: tax.@MinMaxCurrency,
                    pointsAmount: tax.@PointsAmount,
                    publishedAmount: tax.@PublishedAmount,
                    publishedCurrency: tax.@PublishedCurrency,
                    rateUsed: tax.@RateUsed,
                    refundable: tax.@Refundable,
                    reissueCurrency: tax.@ReissueCurrency,
                    reissueMaxAmount: tax.@ReissueMaxAmount,
                    reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                    reissueTaxRefundable: tax.@ReissueTaxRefundable,
                    reissueTaxType: tax.@ReissueTaxType,
                    stationCode: tax.@StationCode,
                    taxCode: tax.@TaxCode,
                    taxOnChangeFee: tax.@TaxOnChangeFee
                  }),
                  taxSummary: legTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                    amount: taxSummary.@Amount,
                    countryCode: taxSummary.@CountryCode,
                    currencyCode: taxSummary.@CurrencyCode,
                    decimalPlaces: taxSummary.@DecimalPlaces,
                    pointsAmount: taxSummary.@PointsAmount,
                    publishedAmount: taxSummary.@PublishedAmount,
                    publishedCurrency: taxSummary.@PublishedCurrency,
                    stationCode: taxSummary.@StationCode,
                    taxCode: taxSummary.@TaxCode
                  })
                })
              },
              tax: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                amount: tax.@Amount,
                applyToReissue: tax.@ApplyToReissue,
                carrierCode: tax.@CarrierCode,
                countryCode: tax.@CountryCode,
                currencyCode: tax.@CurrencyCode,
                decimalPlaces: tax.@DecimalPlaces,
                maxAmount: tax.@MaxAmount,
                minAmount: tax.@MinAmount,
                minMaxCurrency: tax.@MinMaxCurrency,
                pointsAmount: tax.@PointsAmount,
                publishedAmount: tax.@PublishedAmount,
                publishedCurrency: tax.@PublishedCurrency,
                rateUsed: tax.@RateUsed,
                refundable: tax.@Refundable,
                reissueCurrency: tax.@ReissueCurrency,
                reissueMaxAmount: tax.@ReissueMaxAmount,
                reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                reissueTaxRefundable: tax.@ReissueTaxRefundable,
                reissueTaxType: tax.@ReissueTaxType,
                stationCode: tax.@StationCode,
                taxCode: tax.@TaxCode,
                taxOnChangeFee: tax.@TaxOnChangeFee
              }),
              taxSummary: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                amount: taxSummary.@Amount,
                countryCode: taxSummary.@CountryCode,
                currencyCode: taxSummary.@CurrencyCode,
                decimalPlaces: taxSummary.@DecimalPlaces,
                pointsAmount: taxSummary.@PointsAmount,
                publishedAmount: taxSummary.@PublishedAmount,
                publishedCurrency: taxSummary.@PublishedCurrency,
                stationCode: taxSummary.@StationCode,
                taxCode: taxSummary.@TaxCode
              }),
              totalTax: {
                amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#TotalTax.@Amount,
                currencyCode: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#TotalTax.@CurrencyCode,
                decimalPlaces: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#Taxes.ns0#TotalTax.@DecimalPlaces
              }
            },
            totalFare: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalFare.@Amount,
              currencyCode: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalFare.@CurrencyCode,
              decimalPlaces: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalFare.@DecimalPlaces
            },
            totalMileage: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalMileage.@Amount
            },
            totalWithExtras: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#TotalWithExtras.@Amount
            },
            tpaExtensions: {
              baggageInformationList: {
                baggageInformation: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#BaggageInformationList.*ns0#BaggageInformation default [] map ((baggageInformation, indexOfBaggageInformation) -> {
                  airlineCode: baggageInformation.@AirlineCode,
                  allowance: baggageInformation.*ns0#Allowance default [] map ((allowance, indexOfAllowance) -> {
                    description1: allowance.@Description1,
                    description2: allowance.@Description2,
                    pieces: allowance.@Pieces,
                    unit: allowance.@Unit,
                    weight: allowance.@Weight
                  }),
                  charge: baggageInformation.*ns0#Charge default [] map ((charge, indexOfCharge) -> {
                    description1: charge.@Description1,
                    description2: charge.@Description2,
                    equivalentAmount: charge.@EquivalentAmount,
                    equivalentCurrency: charge.@EquivalentCurrency,
                    firstPiece: charge.@FirstPiece,
                    lastPiece: charge.@LastPiece,
                    noChargeNotAvailable: charge.@NoChargeNotAvailable
                  }),
                  provisionType: baggageInformation.@ProvisionType,
                  segment: baggageInformation.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
                    id: segment.@Id
                  })
                })
              },
              commissionData: {
                cat35CommissionAmount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionAmount,
                cat35CommissionPercentage: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionPercentage,
                cat35MarkupAmount: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35MarkupAmount,
                commissionAmountInEquivalent: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionAmountInEquivalent,
                commissionSource: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionSource,
                vccInformation: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#CommissionData.*ns0#VCCInformation default [] map ((vCCInformation, indexOfVCCInformation) -> {
                  commissionAmount: vCCInformation.@CommissionAmount,
                  commissionContractQualifier: vCCInformation.@CommissionContractQualifier,
                  commissionPercent: vCCInformation.@CommissionPercent,
                  earnedCommissionAmount: vCCInformation.@EarnedCommissionAmount,
                  fareComponentBreakdown: vCCInformation.*ns0#FareComponentBreakdown default [] map ((fareComponentBreakdown, indexOfFareComponentBreakdown) -> {
                    contractFamilyId: fareComponentBreakdown.@ContractFamilyID,
                    contractId: fareComponentBreakdown.@ContractID,
                    earnedFareComponentCommission: fareComponentBreakdown.@EarnedFareComponentCommission,
                    fareComponentCommission: fareComponentBreakdown.@FareComponentCommission,
                    fareComponentReferenceId: fareComponentBreakdown.@FareComponentReferenceID,
                    methodId: fareComponentBreakdown.@MethodID,
                    ruleFamilyId: fareComponentBreakdown.@RuleFamilyID,
                    ruleId: fareComponentBreakdown.@RuleID
                  }),
                  totalAmountIncludingMarkUp: vCCInformation.@TotalAmountIncludingMarkUp,
                  validatingCarrier: vCCInformation.@ValidatingCarrier
                })
              },
              fareComponents: {
                fareComponent: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#FareComponents.*ns0#FareComponent default [] map ((fareComponent, indexOfFareComponent) -> {
                  baseFare: {
                    amount: fareComponent.ns0#BaseFare.@Amount,
                    currencyCode: fareComponent.ns0#BaseFare.@CurrencyCode,
                    decimalPlaces: fareComponent.ns0#BaseFare.@DecimalPlaces
                  },
                  brandFeatureRef: fareComponent.*ns0#BrandFeatureRef default [] map ((brandFeatureRef, indexOfBrandFeatureRef) -> {
                    featureId: brandFeatureRef.@FeatureId
                  }),
                  brandId: fareComponent.@BrandID,
                  brandName: fareComponent.@BrandName,
                  equivFare: {
                    amount: fareComponent.ns0#EquivFare.@Amount,
                    currencyCode: fareComponent.ns0#EquivFare.@CurrencyCode,
                    decimalPlaces: fareComponent.ns0#EquivFare.@DecimalPlaces,
                    effectivePriceDeviation: fareComponent.ns0#EquivFare.@EffectivePriceDeviation
                  },
                  fareRetailerRule: fareComponent.*ns0#FareRetailerRule default [] map ((fareRetailerRule, indexOfFareRetailerRule) -> {
                    code: fareRetailerRule.@Code,
                    transactionType: fareRetailerRule.@TransactionType
                  }),
                  handlingMarkupDetail: fareComponent.*ns0#HandlingMarkupDetail default [] map ((handlingMarkupDetail, indexOfHandlingMarkupDetail) -> {
                    amountCurrency: handlingMarkupDetail.@AmountCurrency,
                    fareAmountAfterMarkup: handlingMarkupDetail.@FareAmountAfterMarkup,
                    markupAmount: handlingMarkupDetail.@MarkupAmount,
                    markupHandlingFeeAppId: handlingMarkupDetail.@MarkupHandlingFeeAppID,
                    markupRuleItemNumber: handlingMarkupDetail.@MarkupRuleItemNumber,
                    markupRuleSourcePcc: handlingMarkupDetail.@MarkupRuleSourcePCC,
                    markupTypeCode: handlingMarkupDetail.@MarkupTypeCode,
                    retailerRuleQualifier: handlingMarkupDetail.@RetailerRuleQualifier
                  }),
                  pointsRedemption: {
                    baseFareConversionRate: fareComponent.ns0#PointsRedemption.@BaseFareConversionRate,
                    baseFarePoints: fareComponent.ns0#PointsRedemption.@BaseFarePoints,
                    minimumPoints: fareComponent.ns0#PointsRedemption.@MinimumPoints,
                    surchargesConversionRate: fareComponent.ns0#PointsRedemption.@SurchargesConversionRate,
                    taxConversionRate: fareComponent.ns0#PointsRedemption.@TaxConversionRate,
                    totalPoints: fareComponent.ns0#PointsRedemption.@TotalPoints,
                    totalSurcharges: fareComponent.ns0#PointsRedemption.@TotalSurcharges,
                    totalTaxes: fareComponent.ns0#PointsRedemption.@TotalTaxes
                  },
                  programCode: fareComponent.@ProgramCode,
                  programDescription: fareComponent.@ProgramDescription,
                  programId: fareComponent.@ProgramID,
                  programSystemCode: fareComponent.@ProgramSystemCode,
                  segment: fareComponent.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
                    flightIndex: segment.@FlightIndex,
                    legIndex: segment.@LegIndex
                  }),
                  taxes: {
                    tax: {
                      amount: fareComponent.ns0#Taxes.ns0#Tax.@Amount,
                      applyToReissue: fareComponent.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                      carrierCode: fareComponent.ns0#Taxes.ns0#Tax.@CarrierCode,
                      countryCode: fareComponent.ns0#Taxes.ns0#Tax.@CountryCode,
                      currencyCode: fareComponent.ns0#Taxes.ns0#Tax.@CurrencyCode,
                      decimalPlaces: fareComponent.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                      maxAmount: fareComponent.ns0#Taxes.ns0#Tax.@MaxAmount,
                      minAmount: fareComponent.ns0#Taxes.ns0#Tax.@MinAmount,
                      minMaxCurrency: fareComponent.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                      pointsAmount: fareComponent.ns0#Taxes.ns0#Tax.@PointsAmount,
                      publishedAmount: fareComponent.ns0#Taxes.ns0#Tax.@PublishedAmount,
                      publishedCurrency: fareComponent.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                      rateUsed: fareComponent.ns0#Taxes.ns0#Tax.@RateUsed,
                      refundable: fareComponent.ns0#Taxes.ns0#Tax.@Refundable,
                      reissueCurrency: fareComponent.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                      reissueMaxAmount: fareComponent.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                      reissueRestrictionApplies: fareComponent.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                      reissueTaxRefundable: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                      reissueTaxType: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                      stationCode: fareComponent.ns0#Taxes.ns0#Tax.@StationCode,
                      taxCode: fareComponent.ns0#Taxes.ns0#Tax.@TaxCode,
                      taxOnChangeFee: fareComponent.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
                    }
                  },
                  totalFare: {
                    amount: fareComponent.ns0#TotalFare.@Amount,
                    currencyCode: fareComponent.ns0#TotalFare.@CurrencyCode,
                    decimalPlaces: fareComponent.ns0#TotalFare.@DecimalPlaces
                  }
                })
              },
              legs: {
                leg: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg default [] map ((leg, indexOfLeg) -> {
                  baseFare: {
                    amount: leg.ns0#BaseFare.@Amount,
                    currencyCode: leg.ns0#BaseFare.@CurrencyCode,
                    decimalPlaces: leg.ns0#BaseFare.@DecimalPlaces
                  },
                  equivFare: {
                    amount: leg.ns0#EquivFare.@Amount,
                    currencyCode: leg.ns0#EquivFare.@CurrencyCode,
                    decimalPlaces: leg.ns0#EquivFare.@DecimalPlaces,
                    effectivePriceDeviation: leg.ns0#EquivFare.@EffectivePriceDeviation
                  },
                  fareStatus: leg.@FareStatus,
                  number: leg.@Number,
                  pointsRedemption: {
                    baseFareConversionRate: leg.ns0#PointsRedemption.@BaseFareConversionRate,
                    baseFarePoints: leg.ns0#PointsRedemption.@BaseFarePoints,
                    minimumPoints: leg.ns0#PointsRedemption.@MinimumPoints,
                    surchargesConversionRate: leg.ns0#PointsRedemption.@SurchargesConversionRate,
                    taxConversionRate: leg.ns0#PointsRedemption.@TaxConversionRate,
                    totalPoints: leg.ns0#PointsRedemption.@TotalPoints,
                    totalSurcharges: leg.ns0#PointsRedemption.@TotalSurcharges,
                    totalTaxes: leg.ns0#PointsRedemption.@TotalTaxes
                  },
                  taxes: {
                    tax: {
                      amount: leg.ns0#Taxes.ns0#Tax.@Amount,
                      applyToReissue: leg.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                      carrierCode: leg.ns0#Taxes.ns0#Tax.@CarrierCode,
                      countryCode: leg.ns0#Taxes.ns0#Tax.@CountryCode,
                      currencyCode: leg.ns0#Taxes.ns0#Tax.@CurrencyCode,
                      decimalPlaces: leg.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                      maxAmount: leg.ns0#Taxes.ns0#Tax.@MaxAmount,
                      minAmount: leg.ns0#Taxes.ns0#Tax.@MinAmount,
                      minMaxCurrency: leg.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                      pointsAmount: leg.ns0#Taxes.ns0#Tax.@PointsAmount,
                      publishedAmount: leg.ns0#Taxes.ns0#Tax.@PublishedAmount,
                      publishedCurrency: leg.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                      rateUsed: leg.ns0#Taxes.ns0#Tax.@RateUsed,
                      refundable: leg.ns0#Taxes.ns0#Tax.@Refundable,
                      reissueCurrency: leg.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                      reissueMaxAmount: leg.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                      reissueRestrictionApplies: leg.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                      reissueTaxRefundable: leg.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                      reissueTaxType: leg.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                      stationCode: leg.ns0#Taxes.ns0#Tax.@StationCode,
                      taxCode: leg.ns0#Taxes.ns0#Tax.@TaxCode,
                      taxOnChangeFee: leg.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
                    }
                  },
                  totalFare: {
                    amount: leg.ns0#TotalFare.@Amount,
                    currencyCode: leg.ns0#TotalFare.@CurrencyCode,
                    decimalPlaces: leg.ns0#TotalFare.@DecimalPlaces
                  },
                  totalMileage: {
                    amount: leg.ns0#TotalMileage.@Amount
                  }
                })
              },
              messages: {
                message: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#Messages.*ns0#Message default [] map ((message, indexOfMessage) -> {
                  airlineCode: message.@AirlineCode,
                  failCode: message.@FailCode,
                  info: message.@Info,
                  "type": message.@Type
                })
              },
              pointsRedemption: {
                baseFareConversionRate: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFareConversionRate,
                baseFarePoints: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFarePoints,
                minimumPoints: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@MinimumPoints,
                surchargesConversionRate: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@SurchargesConversionRate,
                taxConversionRate: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TaxConversionRate,
                totalPoints: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalPoints,
                totalSurcharges: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalSurcharges,
                totalTaxes: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalTaxes
              },
              sellingFareDataList: {
                sellingFareData: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".ns0#SellingFareDataList.*ns0#SellingFareData default [] map ((sellingFareDatum, indexOfSellingFareDatum) -> {
                  baseFareAmount: sellingFareDatum.@BaseFareAmount,
                  constructedTotalAmount: sellingFareDatum.@ConstructedTotalAmount,
                  equivalentAmount: sellingFareDatum.@EquivalentAmount,
                  fareCalculation: sellingFareDatum.@FareCalculation,
                  handlingMarkupSummary: sellingFareDatum.*ns0#HandlingMarkupSummary default [] map ((handlingMarkupSummary, indexOfHandlingMarkupSummary) -> {
                    description: handlingMarkupSummary.@Description,
                    monetaryAmountValue: handlingMarkupSummary.@MonetaryAmountValue,
                    typeCode: handlingMarkupSummary.@TypeCode
                  }),
                  layerTypeName: sellingFareDatum.@LayerTypeName,
                  tax: sellingFareDatum.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                    amount: tax.@Amount,
                    applyToReissue: tax.@ApplyToReissue,
                    carrierCode: tax.@CarrierCode,
                    countryCode: tax.@CountryCode,
                    currencyCode: tax.@CurrencyCode,
                    decimalPlaces: tax.@DecimalPlaces,
                    maxAmount: tax.@MaxAmount,
                    minAmount: tax.@MinAmount,
                    minMaxCurrency: tax.@MinMaxCurrency,
                    pointsAmount: tax.@PointsAmount,
                    publishedAmount: tax.@PublishedAmount,
                    publishedCurrency: tax.@PublishedCurrency,
                    rateUsed: tax.@RateUsed,
                    refundable: tax.@Refundable,
                    reissueCurrency: tax.@ReissueCurrency,
                    reissueMaxAmount: tax.@ReissueMaxAmount,
                    reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                    reissueTaxRefundable: tax.@ReissueTaxRefundable,
                    reissueTaxType: tax.@ReissueTaxType,
                    stationCode: tax.@StationCode,
                    taxCode: tax.@TaxCode,
                    taxOnChangeFee: tax.@TaxOnChangeFee
                  }),
                  taxSummary: sellingFareDatum.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                    amount: taxSummary.@Amount,
                    countryCode: taxSummary.@CountryCode,
                    currencyCode: taxSummary.@CurrencyCode,
                    decimalPlaces: taxSummary.@DecimalPlaces,
                    pointsAmount: taxSummary.@PointsAmount,
                    publishedAmount: taxSummary.@PublishedAmount,
                    publishedCurrency: taxSummary.@PublishedCurrency,
                    stationCode: taxSummary.@StationCode,
                    taxCode: taxSummary.@TaxCode
                  }),
                  totalPerPassenger: sellingFareDatum.@TotalPerPassenger,
                  totalTaxes: sellingFareDatum.@TotalTaxes
                })
              },
              surcharges: ticket.ns0#AirItineraryPricingInfo.ns0#ItinTotalFare.ns0#"TPA_Extensions".*ns0#Surcharges default [] map ((surcharge, indexOfSurcharge) -> {
                ind: surcharge.@Ind,
                "type": surcharge.@Type,
                amount: surcharge
              })
            }
          },
          lastTicketDate: ticket.ns0#AirItineraryPricingInfo.@LastTicketDate,
          previousExchangeDate: ticket.ns0#AirItineraryPricingInfo.@PreviousExchangeDate,
          pricingSource: ticket.ns0#AirItineraryPricingInfo.@PricingSource,
          pricingSubSource: ticket.ns0#AirItineraryPricingInfo.@PricingSubSource,
          privateFareType: ticket.ns0#AirItineraryPricingInfo.@PrivateFareType,
          pseudoCityCode: ticket.ns0#AirItineraryPricingInfo.@PseudoCityCode,
          ptcFareBreakdowns: {
            ptcFareBreakdown: ticket.ns0#AirItineraryPricingInfo.ns0#"PTC_FareBreakdowns".*ns0#"PTC_FareBreakdown" default [] map ((pTCFareBreakdown, indexOfPTCFareBreakdown) -> {
              endorsements: {
                endorsement: pTCFareBreakdown.ns0#Endorsements.*ns0#Endorsement default [] map ((endorsement, indexOfEndorsement) -> {
                  language: endorsement.@Language
                }),
                nonEndorsableIndicator: pTCFareBreakdown.ns0#Endorsements.@NonEndorsableIndicator,
                nonRefundableIndicator: pTCFareBreakdown.ns0#Endorsements.@NonRefundableIndicator,
                tpaExtensions: pTCFareBreakdown.ns0#Endorsements.ns0#"TPA_Extensions"
              },
              fareBasisCodes: {
                fareBasisCode: pTCFareBreakdown.ns0#FareBasisCodes.*ns0#FareBasisCode default [] map ((fareBasisCode, indexOfFareBasisCode) -> {
                  accountCode: fareBasisCode.@AccountCode,
                  arrivalAirportCode: fareBasisCode.@ArrivalAirportCode,
                  availabilityBreak: fareBasisCode.@AvailabilityBreak,
                  bookingCode: fareBasisCode.@BookingCode,
                  departureAirportCode: fareBasisCode.@DepartureAirportCode,
                  fareCode: fareBasisCode,
                  fareComponentBeginAirport: fareBasisCode.@FareComponentBeginAirport,
                  fareComponentDirectionality: fareBasisCode.@FareComponentDirectionality,
                  fareComponentEndAirport: fareBasisCode.@FareComponentEndAirport,
                  fareComponentReferenceId: fareBasisCode.@FareComponentReferenceID,
                  fareComponentVendorCode: fareBasisCode.@FareComponentVendorCode,
                  govCarrier: fareBasisCode.@GovCarrier,
                  mileage: fareBasisCode.@Mileage,
                  privateFareType: fareBasisCode.@PrivateFareType
                })
              },
              fareInfos: {
                fareInfo: pTCFareBreakdown.ns0#FareInfos.*ns0#FareInfo default [] map ((fareInfo, indexOfFareInfo) -> {
                  arrivalAirport: {
                    codeContext: fareInfo.ns0#ArrivalAirport.@CodeContext,
                    locationCode: fareInfo.ns0#ArrivalAirport.@LocationCode
                  },
                  departureAirport: {
                    codeContext: fareInfo.ns0#DepartureAirport.@CodeContext,
                    locationCode: fareInfo.ns0#DepartureAirport.@LocationCode
                  },
                  departureDate: fareInfo.ns0#DepartureDate,
                  fareReference: fareInfo.ns0#FareReference,
                  marketingAirline: fareInfo.*ns0#MarketingAirline default [] map ((marketingAirline, indexOfMarketingAirline) -> {
                    code: marketingAirline.@Code,
                    codeContext: marketingAirline.@CodeContext,
                    companyShortName: marketingAirline.@CompanyShortName,
                    travelSector: marketingAirline.@TravelSector
                  }),
                  negotiatedFare: fareInfo.@NegotiatedFare,
                  negotiatedFareCode: fareInfo.@NegotiatedFareCode,
                  ruleInfo: {
                    lengthOfStayRules: {
                      maximumStay: {
                        maxStay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@MaxStay,
                        maxStayDate: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@MaxStayDate,
                        returnTimeOfDay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@ReturnTimeOfDay,
                        returnType: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@ReturnType,
                        stayUnit: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MaximumStay.@StayUnit
                      },
                      minimumStay: {
                        minStay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@MinStay,
                        minStayDate: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@MinStayDate,
                        returnTimeOfDay: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@ReturnTimeOfDay,
                        stayUnit: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.ns0#MinimumStay.@StayUnit
                      },
                      stayRestrictionsInd: fareInfo.ns0#RuleInfo.ns0#LengthOfStayRules.@StayRestrictionsInd
                    },
                    resTicketingRules: {
                      advResTicketing: {
                        advResInd: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.@AdvResInd,
                        advReservation: {
                          latestPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestPeriod,
                          latestTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestTimeOfDay,
                          latestUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvReservation.@LatestUnit
                        },
                        advTicketing: {
                          fromDepartPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartPeriod,
                          fromDepartTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartTimeOfDay,
                          fromDepartUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromDepartUnit,
                          fromResPeriod: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResPeriod,
                          fromResTimeOfDay: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResTimeOfDay,
                          fromResUnit: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.ns0#AdvTicketing.@FromResUnit
                        },
                        advTicketingInd: fareInfo.ns0#RuleInfo.ns0#ResTicketingRules.ns0#AdvResTicketing.@AdvTicketingInd
                      }
                    }
                  },
                  tpaExtensions: {
                    cabin: {
                      cabin: fareInfo.ns0#"TPA_Extensions".ns0#Cabin.@Cabin
                    },
                    fareNote: fareInfo.ns0#"TPA_Extensions".*ns0#FareNote default [] map ((fareNote, indexOfFareNote) -> {
                      contentId: fareNote.@ContentID,
                      fareTypeName: fareNote.@FareTypeName,
                      priorityLevel: fareNote.@PriorityLevel
                    }),
                    meal: {
                      code: fareInfo.ns0#"TPA_Extensions".ns0#Meal.@Code
                    },
                    rule: fareInfo.ns0#"TPA_Extensions".*ns0#Rule default [] map ((rule, indexOfRule) -> {
                      id: rule.@ID,
                      "type": rule.@Type
                    }),
                    seatsRemaining: {
                      belowMin: fareInfo.ns0#"TPA_Extensions".ns0#SeatsRemaining.@BelowMin,
                      number: fareInfo.ns0#"TPA_Extensions".ns0#SeatsRemaining.@Number
                    }
                  }
                })
              },
              lastTicketDate: pTCFareBreakdown.@LastTicketDate,
              passengerFare: {
                baseFare: {
                  amount: pTCFareBreakdown.ns0#PassengerFare.ns0#BaseFare.@Amount,
                  currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#BaseFare.@CurrencyCode,
                  decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#BaseFare.@DecimalPlaces
                },
                currencyConversions: {
                  conversion: pTCFareBreakdown.ns0#PassengerFare.ns0#CurrencyConversions.*ns0#Conversion default [] map ((conversion, indexOfConversion) -> {
                    from: conversion.@From,
                    rateOfExchange: conversion.@RateOfExchange,
                    to: conversion.@To
                  })
                },
                equivFare: {
                  amount: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@Amount,
                  currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@CurrencyCode,
                  decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@DecimalPlaces,
                  effectiveDeviationType: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@EffectiveDeviationType,
                  effectivePriceDeviation: pTCFareBreakdown.ns0#PassengerFare.ns0#EquivFare.@EffectivePriceDeviation
                },
                fareConstruction: {
                  amount: pTCFareBreakdown.ns0#PassengerFare.ns0#FareConstruction.@Amount,
                  currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#FareConstruction.@CurrencyCode,
                  decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#FareConstruction.@DecimalPlaces
                },
                fees: {
                  fee: pTCFareBreakdown.ns0#PassengerFare.ns0#Fees.*ns0#Fee default [] map ((fee, indexOfFee) -> {
                    amount: fee.@Amount,
                    currencyCode: fee.@CurrencyCode,
                    decimalPlaces: fee.@DecimalPlaces,
                    feeCode: fee.@FeeCode
                  })
                },
                negotiatedFare: pTCFareBreakdown.ns0#PassengerFare.@NegotiatedFare,
                negotiatedFareCode: pTCFareBreakdown.ns0#PassengerFare.@NegotiatedFareCode,
                nonRefundableBaseFare: {
                  amount: pTCFareBreakdown.ns0#PassengerFare.ns0#NonRefundableBaseFare.@Amount,
                  currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#NonRefundableBaseFare.@CurrencyCode,
                  decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#NonRefundableBaseFare.@DecimalPlaces
                },
                obFees: {
                  obFee: pTCFareBreakdown.ns0#PassengerFare.ns0#OBFees.*ns0#OBFee default [] map ((oBFee, indexOfOBFee) -> {
                    amount: oBFee.@Amount,
                    currencyCode: oBFee.@CurrencyCode,
                    decimalPlaces: oBFee.@DecimalPlaces,
                    description: oBFee.@Description,
                    "type": oBFee.@Type
                  }),
                  tTypeAmount: pTCFareBreakdown.ns0#PassengerFare.ns0#OBFees.@TTypeAmount
                },
                penaltiesInfo: {
                  penalty: pTCFareBreakdown.ns0#PassengerFare.ns0#PenaltiesInfo.*ns0#Penalty default [] map ((penalty, indexOfPenalty) -> {
                    amount: penalty.@Amount,
                    applicability: penalty.@Applicability,
                    cat16Info: penalty.@Cat16Info,
                    cat16TextOnly: penalty.*ns0#Cat16TextOnly default [] map ((cat16TextOnly, indexOfCat16TextOnly) -> {
                      fareBasisCode: cat16TextOnly.@FareBasisCode,
                      fareComponentId: cat16TextOnly.@FareComponentID
                    }),
                    changeable: penalty.@Changeable,
                    conditionsApply: penalty.@ConditionsApply,
                    currencyCode: penalty.@CurrencyCode,
                    decimalPlaces: penalty.@DecimalPlaces,
                    refundable: penalty.@Refundable,
                    "type": penalty.@Type
                  })
                },
                rateOfExchange: {
                  value: pTCFareBreakdown.ns0#PassengerFare.ns0#RateOfExchange.@Value
                },
                reissueInfoList: {
                  reissueInfo: pTCFareBreakdown.ns0#PassengerFare.ns0#ReissueInfoList.*ns0#ReissueInfo default [] map ((reissueInfo, indexOfReissueInfo) -> {
                    changeFees: {
                      changeFee: {
                        amount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@Amount,
                        changeFeeNotApplicable: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeNotApplicable,
                        changeFeeWaived: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@ChangeFeeWaived,
                        currencyCode: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@CurrencyCode,
                        decimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@DecimalPlaces,
                        highestChangeFee: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@HighestChangeFee,
                        paymentAmount: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentAmount,
                        paymentCurrency: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentCurrency,
                        paymentDecimalPlaces: reissueInfo.ns0#ChangeFees.ns0#ChangeFee.@PaymentDecimalPlaces
                      }
                    },
                    formOfRefund: reissueInfo.@FormOfRefund,
                    reissueDoesNotAllowElectronicTicket: reissueInfo.@ReissueDoesNotAllowElectronicTicket,
                    reissueRequiresElectronicTicket: reissueInfo.@ReissueRequiresElectronicTicket,
                    reissueResultFromTag: reissueInfo.@ReissueResultFromTag,
                    residualIdicator: reissueInfo.@ResidualIdicator,
                    taxRefundable: reissueInfo.@TaxRefundable,
                    typeOfReissueTransaction: reissueInfo.@TypeOfReissueTransaction,
                    typeOfServiceFee: reissueInfo.@TypeOfServiceFee
                  })
                },
                taxes: {
                  fareComponentsTaxes: {
                    fareComponentTaxes: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#FareComponentsTaxes.*ns0#FareComponentTaxes default [] map ((fareComponentTaxis, indexOfFareComponentTaxis) -> {
                      flightSegment: fareComponentTaxis.*ns0#FlightSegment default [] map ((flightSegment, indexOfFlightSegment) -> {
                        arrivalAirportCode: flightSegment.@ArrivalAirportCode,
                        departureAirportCode: flightSegment.@DepartureAirportCode
                      }),
                      tax: fareComponentTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                        amount: tax.@Amount,
                        applyToReissue: tax.@ApplyToReissue,
                        carrierCode: tax.@CarrierCode,
                        countryCode: tax.@CountryCode,
                        currencyCode: tax.@CurrencyCode,
                        decimalPlaces: tax.@DecimalPlaces,
                        maxAmount: tax.@MaxAmount,
                        minAmount: tax.@MinAmount,
                        minMaxCurrency: tax.@MinMaxCurrency,
                        pointsAmount: tax.@PointsAmount,
                        publishedAmount: tax.@PublishedAmount,
                        publishedCurrency: tax.@PublishedCurrency,
                        rateUsed: tax.@RateUsed,
                        refundable: tax.@Refundable,
                        reissueCurrency: tax.@ReissueCurrency,
                        reissueMaxAmount: tax.@ReissueMaxAmount,
                        reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                        reissueTaxRefundable: tax.@ReissueTaxRefundable,
                        reissueTaxType: tax.@ReissueTaxType,
                        stationCode: tax.@StationCode,
                        taxCode: tax.@TaxCode,
                        taxOnChangeFee: tax.@TaxOnChangeFee
                      }),
                      taxSummary: fareComponentTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                        amount: taxSummary.@Amount,
                        countryCode: taxSummary.@CountryCode,
                        currencyCode: taxSummary.@CurrencyCode,
                        decimalPlaces: taxSummary.@DecimalPlaces,
                        pointsAmount: taxSummary.@PointsAmount,
                        publishedAmount: taxSummary.@PublishedAmount,
                        publishedCurrency: taxSummary.@PublishedCurrency,
                        stationCode: taxSummary.@StationCode,
                        taxCode: taxSummary.@TaxCode
                      })
                    })
                  },
                  legsTaxes: {
                    legTaxes: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#LegsTaxes.*ns0#LegTaxes default [] map ((legTaxis, indexOfLegTaxis) -> {
                      number: legTaxis.@Number,
                      tax: legTaxis.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                        amount: tax.@Amount,
                        applyToReissue: tax.@ApplyToReissue,
                        carrierCode: tax.@CarrierCode,
                        countryCode: tax.@CountryCode,
                        currencyCode: tax.@CurrencyCode,
                        decimalPlaces: tax.@DecimalPlaces,
                        maxAmount: tax.@MaxAmount,
                        minAmount: tax.@MinAmount,
                        minMaxCurrency: tax.@MinMaxCurrency,
                        pointsAmount: tax.@PointsAmount,
                        publishedAmount: tax.@PublishedAmount,
                        publishedCurrency: tax.@PublishedCurrency,
                        rateUsed: tax.@RateUsed,
                        refundable: tax.@Refundable,
                        reissueCurrency: tax.@ReissueCurrency,
                        reissueMaxAmount: tax.@ReissueMaxAmount,
                        reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                        reissueTaxRefundable: tax.@ReissueTaxRefundable,
                        reissueTaxType: tax.@ReissueTaxType,
                        stationCode: tax.@StationCode,
                        taxCode: tax.@TaxCode,
                        taxOnChangeFee: tax.@TaxOnChangeFee
                      }),
                      taxSummary: legTaxis.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                        amount: taxSummary.@Amount,
                        countryCode: taxSummary.@CountryCode,
                        currencyCode: taxSummary.@CurrencyCode,
                        decimalPlaces: taxSummary.@DecimalPlaces,
                        pointsAmount: taxSummary.@PointsAmount,
                        publishedAmount: taxSummary.@PublishedAmount,
                        publishedCurrency: taxSummary.@PublishedCurrency,
                        stationCode: taxSummary.@StationCode,
                        taxCode: taxSummary.@TaxCode
                      })
                    })
                  },
                  tax: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                    amount: tax.@Amount,
                    applyToReissue: tax.@ApplyToReissue,
                    carrierCode: tax.@CarrierCode,
                    countryCode: tax.@CountryCode,
                    currencyCode: tax.@CurrencyCode,
                    decimalPlaces: tax.@DecimalPlaces,
                    maxAmount: tax.@MaxAmount,
                    minAmount: tax.@MinAmount,
                    minMaxCurrency: tax.@MinMaxCurrency,
                    pointsAmount: tax.@PointsAmount,
                    publishedAmount: tax.@PublishedAmount,
                    publishedCurrency: tax.@PublishedCurrency,
                    rateUsed: tax.@RateUsed,
                    refundable: tax.@Refundable,
                    reissueCurrency: tax.@ReissueCurrency,
                    reissueMaxAmount: tax.@ReissueMaxAmount,
                    reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                    reissueTaxRefundable: tax.@ReissueTaxRefundable,
                    reissueTaxType: tax.@ReissueTaxType,
                    stationCode: tax.@StationCode,
                    taxCode: tax.@TaxCode,
                    taxOnChangeFee: tax.@TaxOnChangeFee
                  }),
                  taxSummary: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                    amount: taxSummary.@Amount,
                    countryCode: taxSummary.@CountryCode,
                    currencyCode: taxSummary.@CurrencyCode,
                    decimalPlaces: taxSummary.@DecimalPlaces,
                    pointsAmount: taxSummary.@PointsAmount,
                    publishedAmount: taxSummary.@PublishedAmount,
                    publishedCurrency: taxSummary.@PublishedCurrency,
                    stationCode: taxSummary.@StationCode,
                    taxCode: taxSummary.@TaxCode
                  }),
                  totalTax: {
                    amount: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#TotalTax.@Amount,
                    currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#TotalTax.@CurrencyCode,
                    decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#Taxes.ns0#TotalTax.@DecimalPlaces
                  }
                },
                totalFare: {
                  amount: pTCFareBreakdown.ns0#PassengerFare.ns0#TotalFare.@Amount,
                  currencyCode: pTCFareBreakdown.ns0#PassengerFare.ns0#TotalFare.@CurrencyCode,
                  decimalPlaces: pTCFareBreakdown.ns0#PassengerFare.ns0#TotalFare.@DecimalPlaces
                },
                tpaExtensions: {
                  baggageInformationList: {
                    baggageInformation: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#BaggageInformationList.*ns0#BaggageInformation default [] map ((baggageInformation, indexOfBaggageInformation) -> {
                      airlineCode: baggageInformation.@AirlineCode,
                      allowance: baggageInformation.*ns0#Allowance default [] map ((allowance, indexOfAllowance) -> {
                        description1: allowance.@Description1,
                        description2: allowance.@Description2,
                        pieces: allowance.@Pieces,
                        unit: allowance.@Unit,
                        weight: allowance.@Weight
                      }),
                      charge: baggageInformation.*ns0#Charge default [] map ((charge, indexOfCharge) -> {
                        description1: charge.@Description1,
                        description2: charge.@Description2,
                        equivalentAmount: charge.@EquivalentAmount,
                        equivalentCurrency: charge.@EquivalentCurrency,
                        firstPiece: charge.@FirstPiece,
                        lastPiece: charge.@LastPiece,
                        noChargeNotAvailable: charge.@NoChargeNotAvailable
                      }),
                      provisionType: baggageInformation.@ProvisionType,
                      segment: baggageInformation.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
                        id: segment.@Id
                      })
                    })
                  },
                  commissionData: {
                    cat35CommissionAmount: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionAmount,
                    cat35CommissionPercentage: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35CommissionPercentage,
                    cat35MarkupAmount: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@Cat35MarkupAmount,
                    commissionAmountInEquivalent: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionAmountInEquivalent,
                    commissionSource: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.@CommissionSource,
                    vccInformation: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#CommissionData.*ns0#VCCInformation default [] map ((vCCInformation, indexOfVCCInformation) -> {
                      commissionAmount: vCCInformation.@CommissionAmount,
                      commissionContractQualifier: vCCInformation.@CommissionContractQualifier,
                      commissionPercent: vCCInformation.@CommissionPercent,
                      earnedCommissionAmount: vCCInformation.@EarnedCommissionAmount,
                      fareComponentBreakdown: vCCInformation.*ns0#FareComponentBreakdown default [] map ((fareComponentBreakdown, indexOfFareComponentBreakdown) -> {
                        contractFamilyId: fareComponentBreakdown.@ContractFamilyID,
                        contractId: fareComponentBreakdown.@ContractID,
                        earnedFareComponentCommission: fareComponentBreakdown.@EarnedFareComponentCommission,
                        fareComponentCommission: fareComponentBreakdown.@FareComponentCommission,
                        fareComponentReferenceId: fareComponentBreakdown.@FareComponentReferenceID,
                        methodId: fareComponentBreakdown.@MethodID,
                        ruleFamilyId: fareComponentBreakdown.@RuleFamilyID,
                        ruleId: fareComponentBreakdown.@RuleID
                      }),
                      totalAmountIncludingMarkUp: vCCInformation.@TotalAmountIncludingMarkUp,
                      validatingCarrier: vCCInformation.@ValidatingCarrier
                    })
                  },
                  fareComponents: {
                    fareComponent: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#FareComponents.*ns0#FareComponent default [] map ((fareComponent, indexOfFareComponent) -> {
                      baseFare: {
                        amount: fareComponent.ns0#BaseFare.@Amount,
                        currencyCode: fareComponent.ns0#BaseFare.@CurrencyCode,
                        decimalPlaces: fareComponent.ns0#BaseFare.@DecimalPlaces
                      },
                      brandFeatureRef: fareComponent.*ns0#BrandFeatureRef default [] map ((brandFeatureRef, indexOfBrandFeatureRef) -> {
                        featureId: brandFeatureRef.@FeatureId
                      }),
                      brandId: fareComponent.@BrandID,
                      brandName: fareComponent.@BrandName,
                      equivFare: {
                        amount: fareComponent.ns0#EquivFare.@Amount,
                        currencyCode: fareComponent.ns0#EquivFare.@CurrencyCode,
                        decimalPlaces: fareComponent.ns0#EquivFare.@DecimalPlaces,
                        effectivePriceDeviation: fareComponent.ns0#EquivFare.@EffectivePriceDeviation
                      },
                      fareRetailerRule: fareComponent.*ns0#FareRetailerRule default [] map ((fareRetailerRule, indexOfFareRetailerRule) -> {
                        code: fareRetailerRule.@Code,
                        transactionType: fareRetailerRule.@TransactionType
                      }),
                      handlingMarkupDetail: fareComponent.*ns0#HandlingMarkupDetail default [] map ((handlingMarkupDetail, indexOfHandlingMarkupDetail) -> {
                        amountCurrency: handlingMarkupDetail.@AmountCurrency,
                        fareAmountAfterMarkup: handlingMarkupDetail.@FareAmountAfterMarkup,
                        markupAmount: handlingMarkupDetail.@MarkupAmount,
                        markupHandlingFeeAppId: handlingMarkupDetail.@MarkupHandlingFeeAppID,
                        markupRuleItemNumber: handlingMarkupDetail.@MarkupRuleItemNumber,
                        markupRuleSourcePcc: handlingMarkupDetail.@MarkupRuleSourcePCC,
                        markupTypeCode: handlingMarkupDetail.@MarkupTypeCode,
                        retailerRuleQualifier: handlingMarkupDetail.@RetailerRuleQualifier
                      }),
                      pointsRedemption: {
                        baseFareConversionRate: fareComponent.ns0#PointsRedemption.@BaseFareConversionRate,
                        baseFarePoints: fareComponent.ns0#PointsRedemption.@BaseFarePoints,
                        minimumPoints: fareComponent.ns0#PointsRedemption.@MinimumPoints,
                        surchargesConversionRate: fareComponent.ns0#PointsRedemption.@SurchargesConversionRate,
                        taxConversionRate: fareComponent.ns0#PointsRedemption.@TaxConversionRate,
                        totalPoints: fareComponent.ns0#PointsRedemption.@TotalPoints,
                        totalSurcharges: fareComponent.ns0#PointsRedemption.@TotalSurcharges,
                        totalTaxes: fareComponent.ns0#PointsRedemption.@TotalTaxes
                      },
                      programCode: fareComponent.@ProgramCode,
                      programDescription: fareComponent.@ProgramDescription,
                      programId: fareComponent.@ProgramID,
                      programSystemCode: fareComponent.@ProgramSystemCode,
                      segment: fareComponent.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
                        flightIndex: segment.@FlightIndex,
                        legIndex: segment.@LegIndex
                      }),
                      taxes: {
                        tax: {
                          amount: fareComponent.ns0#Taxes.ns0#Tax.@Amount,
                          applyToReissue: fareComponent.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                          carrierCode: fareComponent.ns0#Taxes.ns0#Tax.@CarrierCode,
                          countryCode: fareComponent.ns0#Taxes.ns0#Tax.@CountryCode,
                          currencyCode: fareComponent.ns0#Taxes.ns0#Tax.@CurrencyCode,
                          decimalPlaces: fareComponent.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                          maxAmount: fareComponent.ns0#Taxes.ns0#Tax.@MaxAmount,
                          minAmount: fareComponent.ns0#Taxes.ns0#Tax.@MinAmount,
                          minMaxCurrency: fareComponent.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                          pointsAmount: fareComponent.ns0#Taxes.ns0#Tax.@PointsAmount,
                          publishedAmount: fareComponent.ns0#Taxes.ns0#Tax.@PublishedAmount,
                          publishedCurrency: fareComponent.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                          rateUsed: fareComponent.ns0#Taxes.ns0#Tax.@RateUsed,
                          refundable: fareComponent.ns0#Taxes.ns0#Tax.@Refundable,
                          reissueCurrency: fareComponent.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                          reissueMaxAmount: fareComponent.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                          reissueRestrictionApplies: fareComponent.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                          reissueTaxRefundable: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                          reissueTaxType: fareComponent.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                          stationCode: fareComponent.ns0#Taxes.ns0#Tax.@StationCode,
                          taxCode: fareComponent.ns0#Taxes.ns0#Tax.@TaxCode,
                          taxOnChangeFee: fareComponent.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
                        }
                      },
                      totalFare: {
                        amount: fareComponent.ns0#TotalFare.@Amount,
                        currencyCode: fareComponent.ns0#TotalFare.@CurrencyCode,
                        decimalPlaces: fareComponent.ns0#TotalFare.@DecimalPlaces
                      }
                    })
                  },
                  legs: {
                    leg: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg default [] map ((leg, indexOfLeg) -> {
                      baseFare: {
                        amount: leg.ns0#BaseFare.@Amount,
                        currencyCode: leg.ns0#BaseFare.@CurrencyCode,
                        decimalPlaces: leg.ns0#BaseFare.@DecimalPlaces
                      },
                      equivFare: {
                        amount: leg.ns0#EquivFare.@Amount,
                        currencyCode: leg.ns0#EquivFare.@CurrencyCode,
                        decimalPlaces: leg.ns0#EquivFare.@DecimalPlaces,
                        effectivePriceDeviation: leg.ns0#EquivFare.@EffectivePriceDeviation
                      },
                      fareStatus: leg.@FareStatus,
                      number: leg.@Number,
                      pointsRedemption: {
                        baseFareConversionRate: leg.ns0#PointsRedemption.@BaseFareConversionRate,
                        baseFarePoints: leg.ns0#PointsRedemption.@BaseFarePoints,
                        minimumPoints: leg.ns0#PointsRedemption.@MinimumPoints,
                        surchargesConversionRate: leg.ns0#PointsRedemption.@SurchargesConversionRate,
                        taxConversionRate: leg.ns0#PointsRedemption.@TaxConversionRate,
                        totalPoints: leg.ns0#PointsRedemption.@TotalPoints,
                        totalSurcharges: leg.ns0#PointsRedemption.@TotalSurcharges,
                        totalTaxes: leg.ns0#PointsRedemption.@TotalTaxes
                      },
                      taxes: {
                        tax: {
                          amount: leg.ns0#Taxes.ns0#Tax.@Amount,
                          applyToReissue: leg.ns0#Taxes.ns0#Tax.@ApplyToReissue,
                          carrierCode: leg.ns0#Taxes.ns0#Tax.@CarrierCode,
                          countryCode: leg.ns0#Taxes.ns0#Tax.@CountryCode,
                          currencyCode: leg.ns0#Taxes.ns0#Tax.@CurrencyCode,
                          decimalPlaces: leg.ns0#Taxes.ns0#Tax.@DecimalPlaces,
                          maxAmount: leg.ns0#Taxes.ns0#Tax.@MaxAmount,
                          minAmount: leg.ns0#Taxes.ns0#Tax.@MinAmount,
                          minMaxCurrency: leg.ns0#Taxes.ns0#Tax.@MinMaxCurrency,
                          pointsAmount: leg.ns0#Taxes.ns0#Tax.@PointsAmount,
                          publishedAmount: leg.ns0#Taxes.ns0#Tax.@PublishedAmount,
                          publishedCurrency: leg.ns0#Taxes.ns0#Tax.@PublishedCurrency,
                          rateUsed: leg.ns0#Taxes.ns0#Tax.@RateUsed,
                          refundable: leg.ns0#Taxes.ns0#Tax.@Refundable,
                          reissueCurrency: leg.ns0#Taxes.ns0#Tax.@ReissueCurrency,
                          reissueMaxAmount: leg.ns0#Taxes.ns0#Tax.@ReissueMaxAmount,
                          reissueRestrictionApplies: leg.ns0#Taxes.ns0#Tax.@ReissueRestrictionApplies,
                          reissueTaxRefundable: leg.ns0#Taxes.ns0#Tax.@ReissueTaxRefundable,
                          reissueTaxType: leg.ns0#Taxes.ns0#Tax.@ReissueTaxType,
                          stationCode: leg.ns0#Taxes.ns0#Tax.@StationCode,
                          taxCode: leg.ns0#Taxes.ns0#Tax.@TaxCode,
                          taxOnChangeFee: leg.ns0#Taxes.ns0#Tax.@TaxOnChangeFee
                        }
                      },
                      totalFare: {
                        amount: leg.ns0#TotalFare.@Amount,
                        currencyCode: leg.ns0#TotalFare.@CurrencyCode,
                        decimalPlaces: leg.ns0#TotalFare.@DecimalPlaces
                      },
                      totalMileage: {
                        amount: leg.ns0#TotalMileage.@Amount
                      }
                    })
                  },
                  messages: {
                    message: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#Messages.*ns0#Message default [] map ((message, indexOfMessage) -> {
                      airlineCode: message.@AirlineCode,
                      failCode: message.@FailCode,
                      info: message.@Info,
                      "type": message.@Type
                    })
                  },
                  pointsRedemption: {
                    baseFareConversionRate: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFareConversionRate,
                    baseFarePoints: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@BaseFarePoints,
                    minimumPoints: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@MinimumPoints,
                    surchargesConversionRate: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@SurchargesConversionRate,
                    taxConversionRate: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TaxConversionRate,
                    totalPoints: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalPoints,
                    totalSurcharges: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalSurcharges,
                    totalTaxes: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#PointsRedemption.@TotalTaxes
                  },
                  sellingFareDataList: {
                    sellingFareData: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".ns0#SellingFareDataList.*ns0#SellingFareData default [] map ((sellingFareDatum, indexOfSellingFareDatum) -> {
                      baseFareAmount: sellingFareDatum.@BaseFareAmount,
                      constructedTotalAmount: sellingFareDatum.@ConstructedTotalAmount,
                      equivalentAmount: sellingFareDatum.@EquivalentAmount,
                      fareCalculation: sellingFareDatum.@FareCalculation,
                      handlingMarkupSummary: sellingFareDatum.*ns0#HandlingMarkupSummary default [] map ((handlingMarkupSummary, indexOfHandlingMarkupSummary) -> {
                        description: handlingMarkupSummary.@Description,
                        monetaryAmountValue: handlingMarkupSummary.@MonetaryAmountValue,
                        typeCode: handlingMarkupSummary.@TypeCode
                      }),
                      layerTypeName: sellingFareDatum.@LayerTypeName,
                      tax: sellingFareDatum.*ns0#Tax default [] map ((tax, indexOfTax) -> {
                        amount: tax.@Amount,
                        applyToReissue: tax.@ApplyToReissue,
                        carrierCode: tax.@CarrierCode,
                        countryCode: tax.@CountryCode,
                        currencyCode: tax.@CurrencyCode,
                        decimalPlaces: tax.@DecimalPlaces,
                        maxAmount: tax.@MaxAmount,
                        minAmount: tax.@MinAmount,
                        minMaxCurrency: tax.@MinMaxCurrency,
                        pointsAmount: tax.@PointsAmount,
                        publishedAmount: tax.@PublishedAmount,
                        publishedCurrency: tax.@PublishedCurrency,
                        rateUsed: tax.@RateUsed,
                        refundable: tax.@Refundable,
                        reissueCurrency: tax.@ReissueCurrency,
                        reissueMaxAmount: tax.@ReissueMaxAmount,
                        reissueRestrictionApplies: tax.@ReissueRestrictionApplies,
                        reissueTaxRefundable: tax.@ReissueTaxRefundable,
                        reissueTaxType: tax.@ReissueTaxType,
                        stationCode: tax.@StationCode,
                        taxCode: tax.@TaxCode,
                        taxOnChangeFee: tax.@TaxOnChangeFee
                      }),
                      taxSummary: sellingFareDatum.*ns0#TaxSummary default [] map ((taxSummary, indexOfTaxSummary) -> {
                        amount: taxSummary.@Amount,
                        countryCode: taxSummary.@CountryCode,
                        currencyCode: taxSummary.@CurrencyCode,
                        decimalPlaces: taxSummary.@DecimalPlaces,
                        pointsAmount: taxSummary.@PointsAmount,
                        publishedAmount: taxSummary.@PublishedAmount,
                        publishedCurrency: taxSummary.@PublishedCurrency,
                        stationCode: taxSummary.@StationCode,
                        taxCode: taxSummary.@TaxCode
                      }),
                      totalPerPassenger: sellingFareDatum.@TotalPerPassenger,
                      totalTaxes: sellingFareDatum.@TotalTaxes
                    })
                  },
                  surcharges: pTCFareBreakdown.ns0#PassengerFare.ns0#"TPA_Extensions".*ns0#Surcharges default [] map ((surcharge, indexOfSurcharge) -> {
                    ind: surcharge.@Ind,
                    "type": surcharge.@Type,
                    amount: surcharge
                  })
                }
              },
              passengerTypeQuantity: {
                age: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Age,
                changeable: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Changeable,
                code: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Code,
                codeContext: pTCFareBreakdown.ns0#PassengerTypeQuantity.@CodeContext,
                index: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Index,
                quantity: pTCFareBreakdown.ns0#PassengerTypeQuantity.@Quantity,
                requestedPassengerIndex: pTCFareBreakdown.ns0#PassengerTypeQuantity.@RequestedPassengerIndex,
                tpaExtensions: {
                  age: {
                    years: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#Age.@Years
                  },
                  birthDate: {
                    date: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#BirthDate.@Date
                  },
                  state: {
                    code: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#State.@Code
                  },
                  totalNumber: {
                    value: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#TotalNumber.@Value
                  },
                  voluntaryChanges: {
                    match: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#VoluntaryChanges.@Match,
                    penalty: pTCFareBreakdown.ns0#PassengerTypeQuantity.ns0#"TPA_Extensions".ns0#VoluntaryChanges.*ns0#Penalty default [] map ((penalty, indexOfPenalty) -> {
                      amount: penalty.@Amount,
                      application: penalty.@Application,
                      currencyCode: penalty.@CurrencyCode,
                      decimalPlaces: penalty.@DecimalPlaces,
                      exclude: penalty.@Exclude,
                      "type": penalty.@Type
                    })
                  }
                },
                uri: pTCFareBreakdown.ns0#PassengerTypeQuantity.@URI
              },
              previousExchangeDate: pTCFareBreakdown.@PreviousExchangeDate,
              pricingSource: pTCFareBreakdown.@PricingSource,
              privateFareType: pTCFareBreakdown.@PrivateFareType,
              reissueExchange: pTCFareBreakdown.@ReissueExchange,
              (tpaExtensions: {
                fareCalcLine: {
                  info: pTCFareBreakdown.ns0#"TPA_Extensions".ns0#FareCalcLine.@Info
                },
                fareType: {
                  name: pTCFareBreakdown.ns0#"TPA_Extensions".ns0#FareType.@Name
                }
              }) if pTCFareBreakdown.ns0#"TPA_Extensions"?
            })
          },
          purchaseByDate: ticket.ns0#AirItineraryPricingInfo.@PurchaseByDate,
          reissueExchange: ticket.ns0#AirItineraryPricingInfo.@ReissueExchange,
          repriced: ticket.ns0#AirItineraryPricingInfo.@Repriced,
          spanishFamilyDiscountIndicator: ticket.ns0#AirItineraryPricingInfo.@SpanishFamilyDiscountIndicator,
          timeToLive: ticket.ns0#AirItineraryPricingInfo.@TimeToLive,
          tpaExtensions: {
            ancillaryFeeGroups: {
              ancillaryFeeGroup: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#AncillaryFeeGroups.*ns0#AncillaryFeeGroup default [] map ((ancillaryFeeGroup, indexOfAncillaryFeeGroup) -> {
                ancillaryFeeItem: ancillaryFeeGroup.*ns0#AncillaryFeeItem default [] map ((ancillaryFeeItem, indexOfAncillaryFeeItem) -> {
                  amount: ancillaryFeeItem.@Amount,
                  carrier: ancillaryFeeItem.@Carrier,
                  date: ancillaryFeeItem.@Date,
                  description: ancillaryFeeItem.@Description,
                  destinationAirport: ancillaryFeeItem.@DestinationAirport,
                  endSegment: ancillaryFeeItem.@EndSegment,
                  originAirport: ancillaryFeeItem.@OriginAirport,
                  passengerCode: ancillaryFeeItem.@PassengerCode,
                  startSegment: ancillaryFeeItem.@StartSegment
                }),
                code: ancillaryFeeGroup.@Code,
                message: ancillaryFeeGroup.@Message,
                name: ancillaryFeeGroup.@Name
              }),
              message: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#AncillaryFeeGroups.@Message
            },
            divideInParty: {
              indicator: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#DivideInParty.@Indicator
            },
            fareNote: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#FareNote default [] map ((fareNote, indexOfFareNote) -> {
              contentId: fareNote.@ContentID,
              fareTypeName: fareNote.@FareTypeName,
              priorityLevel: fareNote.@PriorityLevel
            }),
            legs: {
              leg: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg default [] map ((leg, indexOfLeg) -> {
                brandDescription: leg.@BrandDescription,
                brandId: leg.@BrandID,
                fareStatus: leg.@FareStatus,
                number: leg.@Number,
                programCode: leg.@ProgramCode,
                programId: leg.@ProgramID,
                programName: leg.@ProgramName,
                programSystemCode: leg.@ProgramSystemCode,
                segment: leg.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
                  brandId: segment.@BrandID,
                  brandName: segment.@BrandName,
                  fareStatus: segment.@FareStatus,
                  number: segment.@Number,
                  programCode: segment.@ProgramCode,
                  programDescription: segment.@ProgramDescription,
                  programId: segment.@ProgramID,
                  programSystemCode: segment.@ProgramSystemCode
                })
              })
            },
            multipleTravelerGroups: {
              groupNumber: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#MultipleTravelerGroups.@GroupNumber,
              primaryGroup: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#MultipleTravelerGroups.@PrimaryGroup
            },
            promoOffer: {
              contentId: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoOffer.@ContentID,
              corpId: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoOffer.@CorpID,
              promoId: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoOffer.@PromoID
            },
            promoRedemption: {
              contentId: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoRedemption.@ContentID,
              eligible: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoRedemption.@Eligible,
              promoId: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoRedemption.@PromoID
            },
            rule: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#Rule default [] map ((rule, indexOfRule) -> {
              id: rule.@ID,
              "type": rule.@Type
            }),
            unflownPrice: {
              amount: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#UnflownPrice.@Amount,
              currencyCode: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#UnflownPrice.@CurrencyCode,
              decimalPlaces: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".ns0#UnflownPrice.@DecimalPlaces
            },
            validatingCarrier: ticket.ns0#AirItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#ValidatingCarrier default [] map ((validatingCarrier, indexOfValidatingCarrier) -> {
              alternate: validatingCarrier.*ns0#Alternate default [] map ((alternate, indexOfAlternate) -> {
                code: alternate.@Code,
                ietCountryWobsp: {
                  country: alternate.ns0#IETCountryWOBSP.*ns0#Country default [] map ((country, indexOfCountry) -> {
                    code: country.@Code
                  })
                }
              }),
              country: validatingCarrier.@Country,
              "default": {
                code: validatingCarrier.ns0#Default.@Code,
                ietCountryWobsp: {
                  country: validatingCarrier.ns0#Default.ns0#IETCountryWOBSP.*ns0#Country default [] map ((country, indexOfCountry) -> {
                    code: country.@Code
                  })
                }
              },
              newVcxProcess: validatingCarrier.@NewVcxProcess,
              otherTicketing: validatingCarrier.*ns0#OtherTicketing default [] map ((otherTicketing, indexOfOtherTicketing) -> {
                code: otherTicketing.@Code,
                ietCountryWobsp: {
                  country: otherTicketing.ns0#IETCountryWOBSP.*ns0#Country default [] map ((country, indexOfCountry) -> {
                    code: country.@Code
                  })
                }
              }),
              settlementMethod: validatingCarrier.@SettlementMethod
            })
          }
        },
        notes: ticket.*ns0#Notes default [] map ((note, indexOfNote) -> {
          language: note.@Language
        }),
        number: ticket.@Number,
        originDestinationOptions: {
          originDestinationOption: ticket.ns0#OriginDestinationOptions.*ns0#OriginDestinationOption default [] map ((originDestinationOption, indexOfOriginDestinationOption) -> {
            flightSegment: originDestinationOption.*ns0#FlightSegment default [] map ((flightSegment, indexOfFlightSegment) -> {
              arrivalAirport: {
                codeContext: flightSegment.ns0#ArrivalAirport.@CodeContext,
                locationCode: flightSegment.ns0#ArrivalAirport.@LocationCode
              },
              departureAirport: {
                codeContext: flightSegment.ns0#DepartureAirport.@CodeContext,
                locationCode: flightSegment.ns0#DepartureAirport.@LocationCode
              },
              departureDateTime: flightSegment.@DepartureDateTime
            })
          })
        },
        ticketingInfo: {
          eTicketNumber: ticket.ns0#TicketingInfo.@eTicketNumber,
          ticketAdvisory: ticket.ns0#TicketingInfo.*ns0#TicketAdvisory default [] map ((ticketAdvisory, indexOfTicketAdvisory) -> {
            language: ticketAdvisory.@Language
          }),
          ticketTimeLimit: ticket.ns0#TicketingInfo.@TicketTimeLimit,
          ticketType: ticket.ns0#TicketingInfo.@TicketType,
          tpaExtensions: ticket.ns0#TicketingInfo.ns0#"TPA_Extensions",
          validInterline: ticket.ns0#TicketingInfo.@ValidInterline
        },
        tpaExtensions: {
          validatingCarrier: {
            code: ticket.ns0#"TPA_Extensions".ns0#ValidatingCarrier.@Code
          }
        }
      })
    }) if airItineraryPricingInfo.ns0#Tickets.*ns0#Ticket?,
    timeToLive: airItineraryPricingInfo.@TimeToLive,
    tpaExtensions: {
      (ancillaryFeeGroups: {
        ancillaryFeeGroup: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#AncillaryFeeGroups.*ns0#AncillaryFeeGroup default [] map ((ancillaryFeeGroup, indexOfAncillaryFeeGroup) -> {
          ancillaryFeeItem: ancillaryFeeGroup.*ns0#AncillaryFeeItem default [] map ((ancillaryFeeItem, indexOfAncillaryFeeItem) -> {
            amount: ancillaryFeeItem.@Amount,
            carrier: ancillaryFeeItem.@Carrier,
            date: ancillaryFeeItem.@Date,
            description: ancillaryFeeItem.@Description,
            destinationAirport: ancillaryFeeItem.@DestinationAirport,
            endSegment: ancillaryFeeItem.@EndSegment,
            originAirport: ancillaryFeeItem.@OriginAirport,
            passengerCode: ancillaryFeeItem.@PassengerCode,
            startSegment: ancillaryFeeItem.@StartSegment
          }),
          code: ancillaryFeeGroup.@Code,
          message: ancillaryFeeGroup.@Message,
          name: ancillaryFeeGroup.@Name
        }),
        message: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#AncillaryFeeGroups.@Message
      }) if airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#AncillaryFeeGroups.*ns0#AncillaryFeeGroup?,
      (divideInParty: {
        indicator: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#DivideInParty.@Indicator
      }) if airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#DivideInParty?,
      (fareNote: airItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#FareNote default [] map ((fareNote, indexOfFareNote) -> {
        contentId: fareNote.@ContentID,
        fareTypeName: fareNote.@FareTypeName,
        priorityLevel: fareNote.@PriorityLevel
      })) if airItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#FareNote?,
      (legs: {
        leg: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg default [] map ((leg, indexOfLeg) -> {
          brandDescription: leg.@BrandDescription,
          brandId: leg.@BrandID,
          fareStatus: leg.@FareStatus,
          number: leg.@Number,
          programCode: leg.@ProgramCode,
          programId: leg.@ProgramID,
          programName: leg.@ProgramName,
          programSystemCode: leg.@ProgramSystemCode,
          segment: leg.*ns0#Segment default [] map ((segment, indexOfSegment) -> {
            brandId: segment.@BrandID,
            brandName: segment.@BrandName,
            fareStatus: segment.@FareStatus,
            number: segment.@Number,
            programCode: segment.@ProgramCode,
            programDescription: segment.@ProgramDescription,
            programId: segment.@ProgramID,
            programSystemCode: segment.@ProgramSystemCode
          })
        })
      }) if airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#Legs.*ns0#Leg?,
      (multipleTravelerGroups: {
        groupNumber: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#MultipleTravelerGroups.@GroupNumber,
        primaryGroup: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#MultipleTravelerGroups.@PrimaryGroup
      }) if airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#MultipleTravelerGroups?,
      (promoOffer: {
        contentId: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoOffer.@ContentID,
        corpId: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoOffer.@CorpID,
        promoId: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoOffer.@PromoID
      }) if airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoOffer?,
      (promoRedemption: {
        contentId: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoRedemption.@ContentID,
        eligible: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoRedemption.@Eligible,
        promoId: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoRedemption.@PromoID
      }) if airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#PromoRedemption?,
      (rule: airItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#Rule default [] map ((rule, indexOfRule) -> {
        id: rule.@ID,
        "type": rule.@Type
      })) if airItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#Rule?,
      (unflownPrice: {
        amount: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#UnflownPrice.@Amount,
        currencyCode: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#UnflownPrice.@CurrencyCode,
        decimalPlaces: airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#UnflownPrice.@DecimalPlaces
      }) if airItineraryPricingInfo.ns0#"TPA_Extensions".ns0#UnflownPrice?,
      (validatingCarrier: airItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#ValidatingCarrier default [] map ((validatingCarrier, indexOfValidatingCarrier) -> {
        alternate: validatingCarrier.*ns0#Alternate default [] map ((alternate, indexOfAlternate) -> {
          code: alternate.@Code,
          ietCountryWobsp: {
            country: alternate.ns0#IETCountryWOBSP.*ns0#Country default [] map ((country, indexOfCountry) -> {
              code: country.@Code
            })
          }
        }),
        country: validatingCarrier.@Country,
        "default": {
          code: validatingCarrier.ns0#Default.@Code,
          ietCountryWobsp: {
            country: validatingCarrier.ns0#Default.ns0#IETCountryWOBSP.*ns0#Country default [] map ((country, indexOfCountry) -> {
              code: country.@Code
            })
          }
        },
        newVcxProcess: validatingCarrier.@NewVcxProcess,
        otherTicketing: validatingCarrier.*ns0#OtherTicketing default [] map ((otherTicketing, indexOfOtherTicketing) -> {
          code: otherTicketing.@Code,
          ietCountryWobsp: {
            country: otherTicketing.ns0#IETCountryWOBSP.*ns0#Country default [] map ((country, indexOfCountry) -> {
              code: country.@Code
            })
          }
        }),
        settlementMethod: validatingCarrier.@SettlementMethod
      })) if airItineraryPricingInfo.ns0#"TPA_Extensions".*ns0#ValidatingCarrier?
    }
  }

fun mapPricedItinerary(pricedItinerary) =
  {
    airItinerary: {
      departureDate: pricedItinerary.ns0#AirItinerary.@DepartureDate,
      directionInd: pricedItinerary.ns0#AirItinerary.@DirectionInd,
      originDestinationOptions: {
        originDestinationOption: pricedItinerary.ns0#AirItinerary.ns0#OriginDestinationOptions.*ns0#OriginDestinationOption default [] map ((originDestinationOption, indexOfOriginDestinationOption) -> {
          elapsedTime: originDestinationOption.@ElapsedTime,
          flightSegment: originDestinationOption.*ns0#FlightSegment default [] map ((flightSegment, indexOfFlightSegment) -> {
            actionCode: flightSegment.@ActionCode,
            arrivalAirport: {
              codeContext: flightSegment.ns0#ArrivalAirport.@CodeContext,
              locationCode: flightSegment.ns0#ArrivalAirport.@LocationCode,
              terminalId: flightSegment.ns0#ArrivalAirport.@TerminalID
            },
            arrivalDateTime: flightSegment.@ArrivalDateTime,
            arrivalTimeZone: {
              gmtOffset: flightSegment.ns0#ArrivalTimeZone.@GMTOffset
            },
            departureAirport: {
              codeContext: flightSegment.ns0#DepartureAirport.@CodeContext,
              locationCode: flightSegment.ns0#DepartureAirport.@LocationCode,
              terminalId: flightSegment.ns0#DepartureAirport.@TerminalID
            },
            departureDateTime: flightSegment.@DepartureDateTime,
            departureTimeZone: {
              gmtOffset: flightSegment.ns0#DepartureTimeZone.@GMTOffset
            },
            (disclosureAirline: {
              code: flightSegment.ns0#DisclosureAirline.@Code,
              codeContext: flightSegment.ns0#DisclosureAirline.@CodeContext,
              companyShortName: flightSegment.ns0#DisclosureAirline.@CompanyShortName,
              travelSector: flightSegment.ns0#DisclosureAirline.@TravelSector
            }) if flightSegment.ns0#DisclosureAirline?,
            elapsedTime: flightSegment.@ElapsedTime,
            equipment: flightSegment.*ns0#Equipment default [] map ((equipment, indexOfEquipment) -> {
              airEquipType: equipment.@AirEquipType,
              changeofGauge: equipment.@ChangeofGauge
            }),
            flightNumber: flightSegment.@FlightNumber,
            infoSource: flightSegment.@InfoSource,
            marketingAirline: {
              code: flightSegment.ns0#MarketingAirline.@Code,
              codeContext: flightSegment.ns0#MarketingAirline.@CodeContext,
              companyShortName: flightSegment.ns0#MarketingAirline.@CompanyShortName,
              travelSector: flightSegment.ns0#MarketingAirline.@TravelSector
            },
            marriageGrp: flightSegment.ns0#MarriageGrp,
            numberInParty: flightSegment.@NumberInParty,
            onTimePerformance: {
              level: flightSegment.ns0#OnTimePerformance.@Level,
              percentage: flightSegment.ns0#OnTimePerformance.@Percentage
            },
            operatingAirline: {
              code: flightSegment.ns0#OperatingAirline.@Code,
              codeContext: flightSegment.ns0#OperatingAirline.@CodeContext,
              companyShortName: flightSegment.ns0#OperatingAirline.@CompanyShortName,
              flightNumber: flightSegment.ns0#OperatingAirline.@FlightNumber,
              travelSector: flightSegment.ns0#OperatingAirline.@TravelSector
            },
            resBookDesigCode: flightSegment.@ResBookDesigCode,
            rph: flightSegment.@RPH,
            (stopAirports: {
              stopAirport: flightSegment.ns0#StopAirports.*ns0#StopAirport default [] map ((stopAirport, indexOfStopAirport) -> {
                arrivalDateTime: stopAirport.@ArrivalDateTime,
                codeContext: stopAirport.@CodeContext,
                departureDateTime: stopAirport.@DepartureDateTime,
                duration: stopAirport.@Duration,
                elapsedTime: stopAirport.@ElapsedTime,
                equipment: stopAirport.@Equipment,
                gmtOffset: stopAirport.@GMTOffset,
                locationCode: stopAirport.@LocationCode
              })
            }) if flightSegment.ns0#StopAirports?,
            stopQuantity: flightSegment.@StopQuantity,
            tourOperatorFlightId: flightSegment.@TourOperatorFlightID,
            tpaExtensions: {
              (dataElement: {
                subjectToGovernmentApproval: flightSegment.ns0#"TPA_Extensions".ns0#DataElement.@SubjectToGovernmentApproval
              }) if flightSegment.ns0#"TPA_Extensions".ns0#DataElement?,
              eTicket: {
                ind: flightSegment.ns0#"TPA_Extensions".ns0#eTicket.@Ind
              },
              (message: {
                text: flightSegment.ns0#"TPA_Extensions".ns0#Message.@Text,
                "type": flightSegment.ns0#"TPA_Extensions".ns0#Message.@Type
              }) if flightSegment.ns0#"TPA_Extensions".ns0#Message?,
              mileage: {
                amount: flightSegment.ns0#"TPA_Extensions".ns0#Mileage.@Amount
              }
            }
          })
        })
      }
    },
    airItineraryPricingInfo: pricedItinerary.*ns0#AirItineraryPricingInfo default [] map ((airItineraryPricingInfo, indexOfAirItineraryPricingInfo) -> mapAirItineraryPricingInfo(airItineraryPricingInfo)),
    alternateAirport: pricedItinerary.@AlternateAirport,
    campaignId: pricedItinerary.@CampaignID,
    isFromCustomPath: pricedItinerary.@isFromCustomPath,
    multipleTickets: pricedItinerary.@MultipleTickets,
    (notes: pricedItinerary.*ns0#Notes default [] map ((note, indexOfNote) -> {
      language: note.@Language
    })) if pricedItinerary.*ns0#Notes?,
    originDestinationRph: pricedItinerary.@OriginDestinationRPH,
    sequenceNumber: pricedItinerary.@SequenceNumber,
    ticketingInfo: {
      eTicketNumber: pricedItinerary.ns0#TicketingInfo.@eTicketNumber,
      (ticketAdvisory: pricedItinerary.ns0#TicketingInfo.*ns0#TicketAdvisory default [] map ((ticketAdvisory, indexOfTicketAdvisory) -> {
        language: ticketAdvisory.@Language
      })) if pricedItinerary.ns0#TicketingInfo.*ns0#TicketAdvisory?,
      ticketTimeLimit: pricedItinerary.ns0#TicketingInfo.@TicketTimeLimit,
      ticketType: pricedItinerary.ns0#TicketingInfo.@TicketType,
      tpaExtensions: pricedItinerary.ns0#TicketingInfo.ns0#"TPA_Extensions",
      validInterline: pricedItinerary.ns0#TicketingInfo.@ValidInterline
    },
    tpaExtensions: {
      (additionalFares: pricedItinerary.ns0#"TPA_Extensions".*ns0#AdditionalFares default [] map ((additionalFare, indexOfAdditionalFare) -> {
        airItineraryPricingInfo: mapAirItineraryPricingInfo(additionalFare.ns0#AirItineraryPricingInfo),
        multipleTickets: additionalFare.@MultipleTickets,
        notes: additionalFare.*ns0#Notes default [] map ((note, indexOfNote) -> {
          language: note.@Language
        }),
        ticketingInfo: {
          eTicketNumber: additionalFare.ns0#TicketingInfo.@eTicketNumber,
          ticketAdvisory: additionalFare.ns0#TicketingInfo.*ns0#TicketAdvisory default [] map ((ticketAdvisory, indexOfTicketAdvisory) -> {
            language: ticketAdvisory.@Language
          }),
          ticketTimeLimit: additionalFare.ns0#TicketingInfo.@TicketTimeLimit,
          ticketType: additionalFare.ns0#TicketingInfo.@TicketType,
          tpaExtensions: additionalFare.ns0#TicketingInfo.ns0#"TPA_Extensions",
          validInterline: additionalFare.ns0#TicketingInfo.@ValidInterline
        }
      })) if pricedItinerary.ns0#"TPA_Extensions".*ns0#AdditionalFares?,
      (diversitySwapper: {
        weighedPriceAmount: pricedItinerary.ns0#"TPA_Extensions".ns0#DiversitySwapper.@WeighedPriceAmount
      }) if pricedItinerary.ns0#"TPA_Extensions".ns0#DiversitySwapper?,
      (failed: {
        minimumConnectTime: pricedItinerary.ns0#"TPA_Extensions".ns0#Failed.@MinimumConnectTime
      }) if pricedItinerary.ns0#"TPA_Extensions".ns0#Failed?,
      itinSource: {
        source: pricedItinerary.ns0#"TPA_Extensions".ns0#ItinSource.@Source
      },
      (ops: {
        actionCode: pricedItinerary.ns0#"TPA_Extensions".ns0#Ops.@ActionCode,
        fareTypes: {
          fareType: pricedItinerary.ns0#"TPA_Extensions".ns0#Ops.ns0#FareTypes.*ns0#FareType default [] map ((fareType, indexOfFareType) -> {
            code: fareType.@Code
          })
        }
      }) if pricedItinerary.ns0#"TPA_Extensions".ns0#Ops.ns0#FareTypes.*ns0#FareType?,
      (unflownPrice: {
        amount: pricedItinerary.ns0#"TPA_Extensions".ns0#UnflownPrice.@Amount,
        currencyCode: pricedItinerary.ns0#"TPA_Extensions".ns0#UnflownPrice.@CurrencyCode,
        decimalPlaces: pricedItinerary.ns0#"TPA_Extensions".ns0#UnflownPrice.@DecimalPlaces
      }) if pricedItinerary.ns0#"TPA_Extensions".ns0#UnflownPrice?,
      validatingCarrier: {
        code: pricedItinerary.ns0#"TPA_Extensions".ns0#ValidatingCarrier.@Code
      },
      (valueBucket: {
        priceTimeValueRank: pricedItinerary.ns0#"TPA_Extensions".ns0#ValueBucket.@PriceTimeValueRank,
        valueBucketNumber: pricedItinerary.ns0#"TPA_Extensions".ns0#ValueBucket.@ValueBucketNumber
      }) if pricedItinerary.ns0#"TPA_Extensions".ns0#ValueBucket?
    }
  }
output application/json  skipNullOn="everywhere"
---
{
  altLangId: in0.ns0#"OTA_AirLowFareSearchRS".@AltLangID,
  availableItinCount: in0.ns0#"OTA_AirLowFareSearchRS".@AvailableItinCount,
  brandedOneWayItinCount: in0.ns0#"OTA_AirLowFareSearchRS".@BrandedOneWayItinCount,
  departedItinCount: in0.ns0#"OTA_AirLowFareSearchRS".@DepartedItinCount,
  echoToken: in0.ns0#"OTA_AirLowFareSearchRS".@EchoToken,
  (errors: {
    error: in0.ns0#"OTA_AirLowFareSearchRS".ns0#Errors.*ns0#Error map ((error, indexOfError) -> {
      code: error.@Code,
      description: error,
      docUrl: error.@DocURL,
      language: error.@Language,
      messageClass: error.@MessageClass,
      nodeList: error.@NodeList,
      recordId: error.@RecordID,
      shortText: error.@ShortText,
      status: error.@Status,
      tag: error.@Tag,
      "type": error.@Type
    })
  }) if in0.ns0#"OTA_AirLowFareSearchRS".ns0#Errors.*ns0#Error?,
  pricedItinCount: in0.ns0#"OTA_AirLowFareSearchRS".@PricedItinCount,
  (pricedItineraries: {
    (pricedItinerary: in0.ns0#"OTA_AirLowFareSearchRS".ns0#PricedItineraries.*ns0#PricedItinerary map ((pricedItinerary, indexOfPricedItinerary) ->
        mapPricedItinerary(pricedItinerary)
        )
    ) if in0.ns0#"OTA_AirLowFareSearchRS".ns0#PricedItineraries.*ns0#PricedItinerary?,
    tpaExtensions: {
      processingMessage: in0.ns0#"OTA_AirLowFareSearchRS".ns0#PricedItineraries.ns0#"TPA_Extensions".*ns0#ProcessingMessage map ((processingMessage, indexOfProcessingMessage) -> {
        leg: processingMessage.*ns0#Leg map ((leg, indexOfLeg) -> {
          departureDate: leg.@DepartureDate
        }),
        message: processingMessage.@Message,
        pricingSource: processingMessage.@PricingSource
      })
    }
  }) if in0.ns0#"OTA_AirLowFareSearchRS".ns0#PricedItineraries?,
  primaryLangId: in0.ns0#"OTA_AirLowFareSearchRS".@PrimaryLangID,
  sequenceNmbr: in0.ns0#"OTA_AirLowFareSearchRS".@SequenceNmbr,
  simpleOneWayItinCount: in0.ns0#"OTA_AirLowFareSearchRS".@SimpleOneWayItinCount,
  soldOutItinCount: in0.ns0#"OTA_AirLowFareSearchRS".@SoldOutItinCount,
  success: in0.ns0#"OTA_AirLowFareSearchRS".ns0#Success,
  target: in0.ns0#"OTA_AirLowFareSearchRS".@Target,
  timeStamp: in0.ns0#"OTA_AirLowFareSearchRS".@TimeStamp,
  transactionIdentifier: in0.ns0#"OTA_AirLowFareSearchRS".@TransactionIdentifier,
  transactionStatusCode: in0.ns0#"OTA_AirLowFareSearchRS".@TransactionStatusCode,
  version: in0.ns0#"OTA_AirLowFareSearchRS".@Version
}