type User = {name: String}
type Account = {id: Number}
var myUser = {name: "Mariano"}
var myAccount = {id: 3234}
fun openObject(a) =
    a match {
      case x is Account -> x.id
      case x is User -> x.name
    }

fun closeObject(value) =
    value match {
        case a is {| name: String |} -> a.name
        case b is {| name: String, lastName: String|} -> b.name ++ " " ++ b.lastName
        case c is {||} -> "No name"
        else -> "Nothing to see here"
    }

fun repeatedFields(value) =
    value match {
        case a is {name: String} -> "Open single name"
        case a is {|name*: String|} -> "Close multiple names"
        case a is {name*: String} -> "Open multiple names"

    }

fun optionalFields(value) =
    value match {
        case a is {|name?: String, lastName: String|} -> a.name default a.lastName
        case a is {name?: String} -> a.name
    }
---
{
    a: openObject(myUser),
    b: openObject(myAccount),
    c: openObject({name: "Mariano" , lastName: "Achaval"}),

    d: closeObject({name: "Leandro"}),
    e: closeObject({name: "Mariano" , lastName: "Achaval"}),
    f: closeObject({}),
    g: closeObject({name: "Mariano" , lastName: "Achaval", age: 43}),

    h: repeatedFields({name: "Mariano"}),
    i: repeatedFields({name: "Mariano",name: "Mariano",name: "Mariano"}),
    j: repeatedFields({name: "Mariano",name: "Mariano",name: "Mariano", age: 32}),

    k: optionalFields({lastName: "Achaval"}),
    l: optionalFields({age: 32})
}
