
import * from dw::core::Types
type AString = String {n: 1}
type ABoolean = Boolean {n: 1}
type ADate = Date {n: 1}
type ADateTime = DateTime {n: 1}
type ALocalDateTime = LocalDateTime {n: 1}
type ATime = Time {n: 1}
type ATimeZone = TimeZone {n: 1}
type AUri = Uri {n: 1}
type ANamespace = Namespace {n: 1}
type ARange = Range {n: 1}
type APeriod = Period {n: 1}
type ABinary = Binary {n: 1}
type ANull = Null {n: 1}
type ANothing = Nothing {n: 1}
type AAny = Any {n: 1}
type AType = Type {n: 1}
type ARegex = Regex {n: 1}
type AKey = Key {n: 1}

type AObject = {name: String} {n: 1}
type AArray = Array<String> {n: 1}
type AFunction = (String) -> String


type AUnion = String | Number  {n: 1}
type AIntersection = {name: String} & {lastName: String}  {n: 1}
type MyName = "Mariano"
---
{
    a: isStringType(AString),
    b: isStringType(String),
    c: isStringType(Boolean),
    d: isBooleanType(ABoolean),
    e: isBooleanType(Boolean),
    f: isBooleanType(String),
    g: isDateType(ADate),
    h: isDateType(Date),
    i: isDateType(String),
    j: isDateTimeType(ADateTime),
    k: isDateTimeType(DateTime),
    l: isDateTimeType(String),
    m: isLocalDateTimeType(ALocalDateTime),
    n: isLocalDateTimeType(LocalDateTime),
    o: isLocalDateTimeType(String),
    p: isTimeType(ATime),
    q: isTimeType(Time),
    r: isTimeType(String),
    s: isTimeZoneType(ATimeZone),
    t: isTimeZoneType(TimeZone),
    u: isTimeZoneType(String),
    v: isUriType(AUri),
    w: isUriType(Uri),
    x: isUriType(String),
    y: isNamespaceType(ANamespace),
    z: isNamespaceType(Namespace),
    aa: isNamespaceType(String),
    ab: isRangeType(ARange),
    ac: isRangeType(Range),
    ad: isRangeType(String),
    ae: isPeriodType(APeriod),
    af: isPeriodType(Period),
    ag: isPeriodType(String),
    ah: isBinaryType(ABinary),
    ai: isBinaryType(Binary),
    aj: isBinaryType(String),
    ak: isNullType(ANull),
    al: isNullType(Null),
    am: isNullType(String),
    an: isNothingType(ANothing),
    ao: isNothingType(Nothing),
    ap: isNothingType(String),
    aq: isAnyType(AAny),
    ar: isAnyType(Any),
    "as": isAnyType(String),
    "at": isTypeType(AType),
    au: isTypeType(Type),
    av: isTypeType(String),
    aw: isRegexType(ARegex),
    ax: isRegexType(Regex),
    ay: isRegexType(String),
    az: isObjectType(AObject),
    ba: isObjectType(Object),
    bb: isObjectType(String),
    bc: isArrayType(AArray),
    bd: isArrayType(Array),
    be: isArrayType(String),
    bf: isFunctionType(AFunction),
    bg: isFunctionType(String),
    bh: isUnionType(AUnion),
    bi: isUnionType(String),
    bj: isIntersectionType(AIntersection),
    bk: isIntersectionType(String),
    bl: isLiteralType(MyName),
    bm: isLiteralType(Boolean),
}