
import * from org::mule::weave::v2::engine::interceptor_functions::MyLib


fun encryptArg(annotationArgs: {argIndex: Number, encryption?: String}, targetFunctionName: String, args: Array<Any>, callback: (args: Array<Any>) -> String) : String = do {
  var newArgs = args update {
     case password at [annotationArgs.argIndex!] -> "Local<decrypted:$(annotationArgs.encryption default 'SimpleCrypt') of $(password)/>"
  }
  ---
  callback(newArgs)
}


@Interceptor(interceptorFunction = encryptArg)
annotation LocalPasswordDecryptor(argIndex: Number, encryption: String)

@TextAppender(textToAppend = "0 Args")
fun emptyFunction()  = "EmptyFunction"

@TextAppender(textToAppend = "1 Args")
fun oneFunction(arg: String)  = "UnaryFunction: $(arg)"

@TextAppender(textToAppend = "2 Args")
fun twoFunction(arg: String, arg1: String)  = "BinaryFunction: $(arg), $(arg1)"

@TextAppender(textToAppend = "3 Args")
fun threeFunction(arg: String, arg1: String, arg2: String)  = "TernaryFunction: $(arg), $(arg1),$(arg2)"

@TextAppender(textToAppend = "4 Args")
fun fourFunction(arg: String, arg1: String, arg2: String, arg3: String)  = "QuaternaryFunction: $(arg), $(arg1),$(arg2),$(arg3)"

@TextAppender(textToAppend = "5 Args")
fun fiveFunction(arg: String, arg1: String, arg2: String, arg3: String, arg4: String)  = "QuaternaryFunction: $(arg), $(arg1),$(arg2),$(arg3),$(arg4)"

@PasswordDecryptor(argIndex = 1 , encryption = "SimpleCrypt")
fun login(userName: String, password: String) = do {
  {
    userName: userName,
    password: password
  }
}

@LocalPasswordDecryptor(argIndex = 1 , encryption = "SimpleCrypt")
fun localLogin(userName: String, password: String) = do {
  {
    userName: userName,
    password: password
  }
}
---
{
  "empty" : emptyFunction(),
  "one": oneFunction("First Arg"),
  "two": twoFunction("First Arg", "Second Arg"),
  "three": threeFunction("First Arg", "Second Arg", "Third Arg"),
  "four": fourFunction("First Arg", "Second Arg", "Third Arg", "Four Arg"),
  "five": fiveFunction("First Arg", "Second Arg", "Third Arg", "Four Arg", "Fifth Arg"),
  "login": login("Machaval", "!&123Word"),
  "localLogin": localLogin("Machaval", "!&123Word")
}