import * from dw::core::Arrays

var arr = [1,2,3,4,5]
---
{
  countBy:                  [1, 2, 3] dw::core::Arrays::countBy (($ mod 2) == 0),
  countByNull:              null dw::core::Arrays::countBy (($ mod 2) == 0),

  sumBy:                    [ { a: 1 }, { a: 2 }, { a: 3 } ] dw::core::Arrays::sumBy $.a,
  sumByNull:                null dw::core::Arrays::sumBy $.a,

  split:                    arr splitAt 3,
  split_0:                  arr splitAt 0,
  split_negative:           arr splitAt -1,
  split_upper_boundary:     arr splitAt 5,
  split_out_upper_boundary: arr splitAt 6,
  split_lower_boudary:      [] splitAt 1,

  take:                     arr take 2,
  take_negative:            arr take -1,
  take_0:                   arr take 0,
  take_1:                   arr take 1,
  take_upper_bound:         arr take 5,
  take_out_upper_bound:     arr take 6,
  take_null:                null take 2,


  drop:                     arr drop 2,
  drop_negative:            arr drop -1,
  drop_0:                   arr drop 0,
  drop_1:                   arr drop 1,
  drop_upper_bound:         arr drop 5,
  drop_out_upper_bound:     arr drop 6,
  drop_null:                null drop 2,

  takeWhile:                arr takeWhile $ <= 2,
  takeWhile_all:            arr takeWhile true,
  takeWhile_none:           arr takeWhile false,
  takeWhileNull:            null takeWhile $ <= 2,

  dropWhile:                arr dropWhile $ <= 2,
  dropWhile_all:            arr dropWhile true,
  dropWhile_none:           arr dropWhile false,
  dropWhileNull:            null dropWhile $ <= 2,

  partition:                arr partition isEven($),
  partition_first:          arr partition ($ == 1),
  partition_last:           arr partition ($ == 5),
  partition_none:           arr partition false,
  partition_all:            arr partition true,
  partitionNull:            null partition isEven($),


  splitAt:                  arr splitAt 2,
  splitAtNull:              null splitAt 2,

  splitWhere:               arr splitWhere ($ > 2),
  splitWhere_first:         arr splitWhere true,
  splitWhere_none:          arr splitWhere false,
  splitWhereNull:           null splitWhere ($ > 2),

  slice_start:              slice(arr, 0, 3),
  slice_end:                slice(arr, 3, 5),
  slice_outside_range:      slice(arr, 3, 7),
  slice_negative:           slice(arr, -1, 2),
  slice_inverted:           slice(arr, 3, 1),
  slice_same_num:           slice(arr, 3, 3),
  slice_empty:              slice([], 0, 0),
  slice_empty_with_range:   slice([], 0, 2),
  slice_both_outside_range: slice(arr, 42, 45),
  slice_null:               slice(null, null, 43),

  indexOf:                  arr indexOf 3,
  indexOf_not_found:        arr indexOf 40,

  indexWhere:               arr indexWhere ($ >= 3),
  indexWhere_not_found:     arr indexWhere (false),
  indexWhereNull:           null indexWhere ($ >= 3),

}
