import countMatches, countCharactersBy, isUpperCase from dw::core::Strings
var str = "hello world!!"
---
{
    count_char:           countMatches(str, "l"),
    count_string:           countMatches(str, "!!"),
    count_zero:           countMatches(str, "k"),
    count_regex:           countMatches(str, /[aeiou]/),
    count_empty:           countMatches("", "hell"),
    count_empty_empty:           countMatches("", ""),
    count_empty_regex:           countMatches("", /[aeiou]/),

    countby_char:       countCharactersBy(str, (item) -> item == "l"),
    countby_upper:       countCharactersBy("helLLOOO woRL!", (item) -> isUpperCase(item)),
    countby_zero:       countCharactersBy(str, (item) -> false),
    countby_sizeof:       countCharactersBy(str, (item) -> true),
    countby_empty:       countCharactersBy("", (item) -> true),
}