%dw 2.0
output application/json

import * from dw::Runtime

var script = "%dw 2.0
             output application/json
             fun pathOf(element: Object, condition: (element: Any) -> Boolean, path: String = ''): Array<String> =
                 entriesOf(element) flatMap ((item, index) -> do {
                         var newPath = path ++ '.' ++ item.key as String
                         var local = if(condition(item.key))
                             [newPath]
                         else
                             []
                         ---
                         item match {
                             case x is Object ->  local ++ pathOf(x, condition, newPath)
                             else -> local
                         }
                     }
                 )
             ---
             pathOf(payload, (item) -> valuesOf(item.@ default {}) contains  \"00\" )"
---
{
  a: run(
  "main.dwl",
  {"main.dwl": script},
  {"payload": {value: write(in0, "application/xml"), mimeType: "application/xml"}},
  {} ,
  {maxStackSize: 10, timeOut: 5000}
  ) then {
      "kind": $.kind,
       "success": $.success,
  },
}