%dw 2.0


fun unaryFunction1(test: {name: String}) = test.name ++ "Fun2"

fun unaryFunction(name: String = "Test") = name ++ "Fun1"


fun binaryFunction1(test: {name: String}, other: {name: Number}) = test.name ++ other.name

fun binaryFunction(name: String = "Test", other: Number) = name ++ other


fun ternaryFunction1(test: {name: String}, other: {name: Number}, test2:  String) = test.name ++ other.name ++ test2

fun ternaryFunction(name: String = "Test", other: Number, test: Boolean) = name ++ other ++ test


fun quaternaryFunction1(test: {name: String}, other: {name: Number}, test2:  String, test3: String) = test.name ++ other.name ++ test2 ++ test3

fun quaternaryFunction(name: String = "Test", other: Number, test: Boolean,  test3: String) = name ++ other ++ test ++ test3

---
{
    UnaryMaterialize:  [{name: "Peter"}, {name: "123"}] map unaryFunction1($),
    Unary:  ["This is", "a" , 1, 2, true, " Bak to String"] map unaryFunction($),
    BinaryMaterialize: [{name: "Peter"}, {name: "123"}] map binaryFunction1($, {name: sizeOf($)}),
    Binary: ["This is", "a" , 1, 2, " Bak to String"] map binaryFunction($, 123),
    TernaryMaterialize: [ {name: "Peter"}, {name: "123"}] map ternaryFunction1($, {name: sizeOf($)}, sizeOf($) as String),
    Ternary: ["This is", "a" , 1, 2, " Bak to String"] map ternaryFunction($, 123, $ == 1),
    QuaternaryMaterialize: [{name: "Peter"}, {name: "123"}] map quaternaryFunction1($, {name: sizeOf($)}, sizeOf($) as String , "123"),
    Quaternary: ["This is", "a" , 1, 2, " Bak to String"] map quaternaryFunction($, 123, $ == 1, "456"),

}