%dw 2.0
input in0 application/xml streaming=true,collectionPath="order.order-items"
output application/xml
---
{
  salesorder: {
    details: {
      orderid: in0.order.@id,
      customer: {
        id: in0.order.header.customer.@number,
        name: in0.order.header.customer
      }
    },
    itemList: in0.order."order-items".*"order-item" map {
      ("i_" ++ $$) : {
        id: $.@id,
        productId: $.product,
        quantity: $.quantity,
        price: $.price
      }
    }
  }
}