%dw 2.0
output application/json
fun pathOf(element: Object, condition: (element: Any) -> Boolean, path: String = ''): Array<String> =
   entriesOf(element) flatMap ((item, index) -> do {
           var newPath = path ++ '.' ++ item.key as String
           var local = if(condition(item))
               [newPath]
           else
               []
           ---
           item match {
               case x is {value: Object} ->  local ++ pathOf(x.value, condition, newPath)
               else -> local
           }
       }
   )
---
pathOf(in0, (item) -> valuesOf(item.attributes default {}) contains  "00" )