%dw 2.0

fun test(a: String) = "`test` function value is $(a)"

fun otherTest(a: {test: "123"}) = "`otherTest` function value is $(a.test)"

fun generic<T>(t: T) =
  t match {
  	case a is String -> test(a)
  	else -> "Your value is $(t as String)"
  }

fun genericObject<T>(t: {test: T}) =
  t match {
    case z is {test: "123"} -> otherTest(z)
    else -> "Your value is $(t.test as String)"
  }

fun genericUpperBound<U <: T, T <: String>(t: {test: U}) =
  t match {
    case z is {test: "123"} -> otherTest(z)
    else -> "Your value is $(t.test)"
  }

---
{
   a: generic("my string value"),
   b: generic(1),
   c: genericObject({test: "123"}),
   d: genericObject({test: 465}),
   e: genericUpperBound({test: "123"}),
   f: genericUpperBound({test: "465"})
}


