%dw 2.0
output application/json
---
(
    in0
        filter $.status != 'deprecated'
        map ((item, index) -> splitBy(item.version, "."))
        groupBy ((item, index) -> item[0] ++ "." ++ item[1])
        mapObject ((value, key, index) -> {
            '$(key)' : {
                latest : max((value map ((item, index) -> item[2]))),
                toDeprecate : ((value map ((item, index) -> item[2])) - max((value map ((item, index) -> item[2])))) map ((item, index) -> key ++ "." ++ item)
            }
        })
)..toDeprecate reduce ((item, accumulator = []) -> item ++ accumulator)