var payload = 
do {
  ns doc http://www.mulesoft.org/schema/mule/documentation
  ns http http://www.mulesoft.org/schema/mule/http
  ns ns2 http://www.mulesoft.org/schema/mule/core
  ---
  {
    http#"listener-config" @(name: "HTTP_Listener_config", doc#name: "HTTP Listener config", doc#id: "fa279058-3353-467b-9934-b226eee92430"): {
      http#"listener-connection" @(host: "0.0.0.0", port: "8081"): null
    },
    ns2#flow @(name: "javaFlow", doc#id: "0f1153c1-84da-40f2-a53a-dc2108e2e664"): {
      http#listener @(doc#name: "Listener", doc#id: "121ddf74-93a0-446f-8578-7cf281607870", "config-ref": "HTTP_Listener_config", path: "/test"): null,
      ns2#logger @(level: "INFO", doc#name: "Logger", doc#id: "d16f3c03-5c98-4925-96c6-47247c7eda1e"): null
    }
  }
}

import * from dw::core::Objects

fun resolveType(typeName: String) : String = if(typeName == 'flow') 'flow' else "config"

fun id(element: Object) : Any = if(element.id != null) element.id else 'XXX'

fun processElement(element: Object, parentId: String ) : Object =
    processElement(element.value, element.attributes, element.key, parentId)

fun processElement(element: Object, attributes: Object, key: String, parentId: String) =
    {
        name : attributes.name,
        "type" : resolveType(key),
        "id" : id(attributes),
    }
---
entrySet(payload) map ((item, index) -> processElement(item, uuid()))