

fun appendText(annotationArgs: {textToAppend: String}, targetFunctionName: String, args: Array<Any>, callback: (args: Array<Any>) -> String) : String = do {
  var suffix = annotationArgs.textToAppend ++ " When calling $(targetFunctionName)"
  ---
  callback(args) ++ suffix
}

@Interceptor(interceptorFunction = appendText)
annotation TextAppender(textToAppend: String)


fun encryptArg(annotationArgs: {argIndex: Number, encryption?: String}, targetFunctionName: String, args: Array<Any>, callback: (args: Array<Any>) -> String) : String = do {
  var newArgs = args update {
     case password at [annotationArgs.argIndex!] -> "<decrypted:$(annotationArgs.encryption default 'SimpleCrypt') of $(password)/>"
  }
  ---
  callback(newArgs)
}


@Interceptor(interceptorFunction = encryptArg)
annotation PasswordDecryptor(argIndex: Number, encryption: String)
