ns ns1 http://acme.com
type User = {name: String}
type Account = {id: Number}
type Catalog = {
  user : User,
  account: Account,
  closedWithName : {| name: User.name |},
  closedWithNameAndLastName: {| name: User.name, lastName: User.name|},
  closedEmpty: {||},
  openWithName: {name: String},
  closedWithMultipleNames: {|name*: String|},
  openWithMultipleNames: {name*: String},
  optionalNameAndLastname: {|name?: String, lastName: String|},
  optionalName: {name?: String}
}
type Test = { ns1#message: String, number: Number, numberOrString: String | Number }
type WithParameters<A, B> = {first: A, second: B}

var myUser = {name: "Mariano"}
var myAccount = {id: 3234}

fun openObject(a) =
    a match {
      case x is Catalog.account -> x.id
      case x is Catalog.user -> x.name
    }

fun closeObject(value) =
    value match {
        case a is Catalog.closedWithName -> a.name
        case b is Catalog.closedWithNameAndLastName -> b.name ++ " " ++ b.lastName
        case c is Catalog.closedEmpty -> "No name"
        else -> "Nothing to see here"
    }

fun repeatedFields(value) =
    value match {
        case a is Catalog.openWithName -> "Open single name"
        case a is Catalog.closedWithMultipleNames -> "Close multiple names"
        case a is Catalog.openWithMultipleNames -> "Open multiple names"
    }

fun optionalFields(value) =
    value match {
        case a is Catalog.optionalNameAndLastname -> a.name default a.lastName
        case a is Catalog.optionalName -> a.name
    }

fun withParameters(value) =
    value match {
        case a is WithParameters<String, Boolean>.first -> "1"
        case a is WithParameters<String, Boolean>.second -> "2"
        case a is WithParameters<String, Test.number>.second -> "3"
    }

---
{
    a: openObject(myUser),
    b: openObject(myAccount),
    c: openObject({name: "Mariano" , lastName: "Achaval"}),

    d: closeObject({name: "Leandro"}),
    e: closeObject({name: "Mariano" , lastName: "Achaval"}),
    f: closeObject({}),
    g: closeObject({name: "Mariano" , lastName: "Achaval", age: 43}),

    h: repeatedFields({name: "Mariano"}),
    i: repeatedFields({name: "Mariano",name: "Mariano",name: "Mariano"}),
    j: repeatedFields({name: "Mariano",name: "Mariano",name: "Mariano", age: 32}),

    k: optionalFields({lastName: "Achaval"}),
    l: optionalFields({age: 32}),

    m: withParameters(""),
    n: withParameters(true),
    o: withParameters(43)
}
