import mustEqual from dw::core::Assertions
import assert from dw::core::Assertions
import dw::core::Binaries

var readData = readUrl("classpath://org/mule/weave/v2/engine/read-binary-files/in0.bin", 'application/octet-stream')

var validations = [
  assert(sizeOf(readData) == sizeOf(in0), "size of readUrl content must equal size of reader value"),
  assert(readData == in0, "readUrl content must equal reader value"),
  assert(Binaries::toBase64(readData) == in1, "generated base 64 must equal in1"),
  assert(Binaries::toBase64(in0) == in1, "base64(in0) == in1"),

  using(fromBase64 = Binaries::fromBase64(in1))
  using(readBinaryDirectly = read(fromBase64, 'application/octet-stream')) [

    assert(sizeOf(fromBase64) == 1183, "Binary from base64 must have the same size as the original file ($(sizeOf(fromBase64)) vs $(1183))"),
    assert(fromBase64 is Binary, "From base64 must be binary"),
    assert(readBinaryDirectly is Binary, "read(binary) must be binary"),
    assert(sizeOf(readBinaryDirectly) == 1183, "sizeOf(read(binary)) must have the same size as the original file ($(sizeOf(readBinaryDirectly)) vs $(1183))"),

    readBinaryDirectly as String mustEqual fromBase64 as String,
    typeOf(readBinaryDirectly) as String mustEqual typeOf(fromBase64) as String,
    sizeOf(readBinaryDirectly) mustEqual sizeOf(fromBase64),
    read(readBinaryDirectly, 'application/octet-stream') mustEqual in0
  ]
]

---
readData