%dw 2.0

type TestTypeObject = {firstLevelType: {secondLevelType: String }, anotherKeyType: Number}

fun unaryFunction1(test: {name: TestTypeObject.firstLevelType.secondLevelType}) = test.name ++ "Fun2"

fun unaryFunction(name: TestTypeObject.firstLevelType.secondLevelType = "Test") = name ++ "Fun1"


fun binaryFunction1(test: {name: TestTypeObject.firstLevelType.secondLevelType}, other: {name: TestTypeObject.anotherKeyType}) = test.name ++ other.name

fun binaryFunction(name: TestTypeObject.firstLevelType.secondLevelType = "Test", other: TestTypeObject.anotherKeyType) = name ++ other


fun ternaryFunction1(test: {name: TestTypeObject.firstLevelType.secondLevelType}, other: {name: TestTypeObject.anotherKeyType}, test2:  TestTypeObject.firstLevelType.secondLevelType) = test.name ++ other.name ++ test2

fun ternaryFunction(name: TestTypeObject.firstLevelType.secondLevelType = "Test", other: TestTypeObject.anotherKeyType, test: Boolean) = name ++ other ++ test


fun quaternaryFunction1(test: {name: TestTypeObject.firstLevelType.secondLevelType}, other: {name: TestTypeObject.anotherKeyType}, test2:  TestTypeObject.firstLevelType.secondLevelType, test3: TestTypeObject.firstLevelType.secondLevelType) = test.name ++ other.name ++ test2 ++ test3

fun quaternaryFunction(name: TestTypeObject.firstLevelType.secondLevelType = "Test", other: TestTypeObject.anotherKeyType, test: Boolean,  test3: TestTypeObject.firstLevelType.secondLevelType) = name ++ other ++ test ++ test3

---
{
    UnaryMaterialize:  [{name: "Peter"}, {name: "123"}] map unaryFunction1($),
    Unary:  ["This is", "a" , 1, 2, true, " Bak to String"] map unaryFunction($),
    BinaryMaterialize: [{name: "Peter"}, {name: "123"}] map binaryFunction1($, {name: sizeOf($)}),
    Binary: ["This is", "a" , 1, 2, " Bak to String"] map binaryFunction($, 123),
    TernaryMaterialize: [ {name: "Peter"}, {name: "123"}] map ternaryFunction1($, {name: sizeOf($)}, sizeOf($) as TestTypeObject.firstLevelType.secondLevelType),
    Ternary: ["This is", "a" , 1, 2, " Bak to String"] map ternaryFunction($, 123, $ == 1),
    QuaternaryMaterialize: [{name: "Peter"}, {name: "123"}] map quaternaryFunction1($, {name: sizeOf($)}, sizeOf($) as TestTypeObject.firstLevelType.secondLevelType , "123"),
    Quaternary: ["This is", "a" , 1, 2, " Bak to String"] map quaternaryFunction($, 123, $ == 1, "456"),

}
