%dw 2.0

import * from dw::Runtime
import * from dw::Client

var response = {
  status: 200,
  body: lazyReadBinary("application/json", "{\"user\":\"Mari" as Binary)
}

---
{
  status: response.status,
  mimeType: response.body.^mimeType,
  raw: response.body.^raw,
  body: do {
    var bodyResult = try(() -> response.body)
    ---
    {
      success: bodyResult.success,
      error: {
        kind: bodyResult.error.kind,
        message: bodyResult.error.message
      },
      result: bodyResult.result
    }
  }
}
