%dw 2.0

ns ns1 http://acme.com
ns ns2 http://acme.com2
ns ns3 http://acme2.com

type NestedFunctionType = {
                            numberToNumber: (Number) -> Number,
                            stringToString: (String) -> String,
                          }

type CatalogType = {boolean: Boolean ,name: String , number: Number, numberToNumberFunction: NestedFunctionType.numberToNumber, stringToStringFunction: NestedFunctionType.stringToString}

fun myFunDifArity(name: CatalogType.name) = name ++ "Fun1"

fun myFunDifArity(name: CatalogType.name, number: CatalogType.number) = name ++ "Fun2"


fun myFunDefaultMethod(name: CatalogType.name, number: CatalogType.number=1) = name ++ number

fun myFunDefaultMethod(number1: CatalogType.number, number2: CatalogType.number=2) = number1 + number2


fun fullOverloaded(name: CatalogType.name, number: CatalogType.number=1) = name ++ number

fun fullOverloaded(number1: CatalogType.number, number2: CatalogType.number=2) = number1 - number2

fun fullOverloaded(boolean1: CatalogType.boolean, boolean2: CatalogType.boolean, boolean3: CatalogType.boolean) = boolean1 or boolean2 and boolean3


fun callerWithNumber(callback: CatalogType.numberToNumberFunction) = callback(1)

fun callerWithString(callback: CatalogType.stringToStringFunction) = callback("Mariano")

fun dict(stringDict: {_ : CatalogType.name}) = stringDict.foo

fun dict(numberDict: {_ : CatalogType.number}) = numberDict.bar

fun a() = "1"
fun a(test) = "2"
fun a(test, test2) = "3"

type TestNS = { ns1#message: String, ns2#message: {ns3#message: Number, ns1#message:Boolean}, message: Boolean, lala: Number}

fun testNS(asdf: TestNS) = "1"
fun testNS(asdf: TestNS.ns1#message) = "2"
fun testNS(asdf: TestNS.ns2#message) = "3"
fun testNS(asdf: TestNS.message) = "4"
---
{
    a: myFunDifArity("This is "),
    b: myFunDifArity("This is ", 2),
    c: myFunDefaultMethod("Mariano "),
    d: myFunDefaultMethod("Mariano ", 2),
    e: myFunDefaultMethod(1),
    f: myFunDefaultMethod(1, 4),
    g: fullOverloaded("Shoki"),
    h: fullOverloaded("Shoki", 23),
    i: fullOverloaded(true, true, true),
    j: callerWithNumber(fullOverloaded),
    k: callerWithString(myFunDefaultMethod),
    l: dict({foo: "Mariano"}),
    m: dict({bar: 32}),
    n: a(in0),
    o: testNS({ns3#message: 21, ns1#message: true})
}
