import * from dw::core::Strings
import * from dw::core::Types

//Customer Module
@Metadata(key = "label")
annotation Label(value: (String)-> String = (v: String) -> "")

@Metadata(key = "description")
annotation Description(value: String = "")


fun resolveLabel(prefix: String) = upper(prefix) ++ "CustomLabel"


type Test = @Description(value="Description Test")
            @Label(value = resolveLabel)
            {
               a: @Description(value="TestDescriptionFix") String
            }

---
{
 "Test Label": Test.^.label("Test"),
 "Test Description": Test.^.description
}