%dw 2.0
output application/json


var ldt: LocalDateTime = |2021-09-01T00:00:00|
var d: Date = |2021-09-10|
var lt: LocalTime = |00:00:00|

fun localDateTimeCoercion(tz: String) = ldt ++ tz
fun localDateTimeCoercionRev(tz: String) = tz ++ ldt

fun dateCoercion(tz: String) = d ++ tz
fun dateCoercionRev(tz: String) = tz ++ d

fun localTimeCoercion(tz: String) = lt ++ tz
fun localTimeCoercionRev(tz: String) = tz ++ lt


---
{
    ldt1: localDateTimeCoercion("GMT-3"),
    ldt2: localDateTimeCoercion("GMTZ"),
    ldt3: localDateTimeCoercion("GMT-3"),

    revldt1: localDateTimeCoercionRev("GMT-3"),
    revldt2: localDateTimeCoercionRev("GMTZ"),
    revldt3: localDateTimeCoercionRev("GMT-3"),

    d1: dateCoercion("GMT-3"),
    d2: dateCoercion("GMT-"),
    d3: dateCoercion("GMT-3"),

    revd1: dateCoercionRev("GMT-3"),
    revd2: dateCoercionRev("GMT-"),
    revd3: dateCoercionRev("GMT-3"),

    lt1: localTimeCoercion("GMT-3"),
    lt2: localTimeCoercion("GMT-"),
    lt3: localTimeCoercion("GMT-3"),

    lt1Rev: localTimeCoercionRev("GMT-3"),
    lt2Rev: localTimeCoercionRev("GMT-"),
    lt3Rev: localTimeCoercionRev("GMT-3"),
}